/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.FormattedHeader;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HeaderElement;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieSpec;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie2;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicCommentHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicDomainHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicExpiresHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicPathHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicSecureHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.NetscapeDraftSpec;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2109DomainHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2109Spec;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2109VersionHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2965Spec;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.message.ParserCursor;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.CharArrayBuffer;
import java.util.List;

@Contract(threading=ThreadingBehavior.SAFE)
public class DefaultCookieSpec
implements CookieSpec {
    private final RFC2965Spec strict;
    private final RFC2109Spec obsoleteStrict;
    private final NetscapeDraftSpec netscapeDraft;

    DefaultCookieSpec(RFC2965Spec strict, RFC2109Spec obsoleteStrict, NetscapeDraftSpec netscapeDraft) {
        this.strict = strict;
        this.obsoleteStrict = obsoleteStrict;
        this.netscapeDraft = netscapeDraft;
    }

    public DefaultCookieSpec(String[] datepatterns, boolean oneHeader) {
        String[] stringArray;
        this.strict = new RFC2965Spec(oneHeader, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
        this.obsoleteStrict = new RFC2109Spec(oneHeader, new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicDomainHandler();
        commonCookieAttributeHandlerArray[1] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (datepatterns != null) {
            stringArray = (String[])datepatterns.clone();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "io.quarkus.launcher.shaded.EEE, dd-MMM-yy HH:mm:ss z";
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
        this.netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
    }

    public DefaultCookieSpec() {
        this(null, false);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(header, "io.quarkus.launcher.shaded.Header");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        HeaderElement[] hElems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement hElem : hElems) {
            if (hElem.getParameterByName("io.quarkus.launcher.shaded.version") != null) {
                versioned = true;
            }
            if (hElem.getParameterByName("io.quarkus.launcher.shaded.expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String hValue = header.getValue();
                if (hValue == null) {
                    throw new MalformedCookieException("io.quarkus.launcher.shaded.Header value is null");
                }
                buffer = new CharArrayBuffer(hValue.length());
                buffer.append(hValue);
                cursor = new ParserCursor(0, buffer.length());
            }
            hElems = new HeaderElement[]{parser.parseHeader(buffer, cursor)};
            return this.netscapeDraft.parse(hElems, origin);
        }
        return "io.quarkus.launcher.shaded.Set-Cookie2".equals(header.getName()) ? this.strict.parse(hElems, origin) : this.obsoleteStrict.parse(hElems, origin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                this.strict.validate(cookie, origin);
            } else {
                this.obsoleteStrict.validate(cookie, origin);
            }
        } else {
            this.netscapeDraft.validate(cookie, origin);
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        if (cookie.getVersion() > 0) {
            return cookie instanceof SetCookie2 ? this.strict.match(cookie, origin) : this.obsoleteStrict.match(cookie, origin);
        }
        return this.netscapeDraft.match(cookie, origin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notNull(cookies, "io.quarkus.launcher.shaded.List of cookies");
        int version = Integer.MAX_VALUE;
        boolean isSetCookie2 = true;
        for (Cookie cookie : cookies) {
            if (!(cookie instanceof SetCookie2)) {
                isSetCookie2 = false;
            }
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        if (version > 0) {
            return isSetCookie2 ? this.strict.formatCookies(cookies) : this.obsoleteStrict.formatCookies(cookies);
        }
        return this.netscapeDraft.formatCookies(cookies);
    }

    @Override
    public int getVersion() {
        return this.strict.getVersion();
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "io.quarkus.launcher.shaded.default";
    }
}

