/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicDomainHandler;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.TextUtils;
import java.util.Locale;
import java.util.StringTokenizer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NetscapeDomainHandler
extends BasicDomainHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (TextUtils.isBlank(value)) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Blank or null value for domain attribute");
        }
        cookie.setDomain(value);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        String domain;
        String host = origin.getHost();
        if (!host.equals(domain = cookie.getDomain()) && !BasicDomainHandler.domainMatch(domain, host)) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Illegal domain attribute \"" + domain + "io.quarkus.launcher.shaded.\". Domain of origin: \"" + host + "io.quarkus.launcher.shaded.\"");
        }
        if (host.contains("io.quarkus.launcher.shaded..")) {
            int domainParts = new StringTokenizer(domain, "io.quarkus.launcher.shaded..").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(domain)) {
                if (domainParts < 2) {
                    throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + domain + "io.quarkus.launcher.shaded.\" violates the Netscape cookie specification for " + "io.quarkus.launcher.shaded.special domains");
                }
            } else if (domainParts < 3) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + domain + "io.quarkus.launcher.shaded.\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String domain) {
        String ucDomain = domain.toUpperCase(Locale.ROOT);
        return ucDomain.endsWith("io.quarkus.launcher.shaded..COM") || ucDomain.endsWith("io.quarkus.launcher.shaded..EDU") || ucDomain.endsWith("io.quarkus.launcher.shaded..NET") || ucDomain.endsWith("io.quarkus.launcher.shaded..GOV") || ucDomain.endsWith("io.quarkus.launcher.shaded..MIL") || ucDomain.endsWith("io.quarkus.launcher.shaded..ORG") || ucDomain.endsWith("io.quarkus.launcher.shaded..INT");
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        return host.endsWith(domain);
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.domain";
    }
}

