/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109DomainHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (value == null) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Missing value for domain attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Blank value for domain attribute");
        }
        cookie.setDomain(value);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Cookie domain may not be null");
        }
        if (!domain.equals(host)) {
            int dotIndex = domain.indexOf(46);
            if (dotIndex == -1) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + domain + "io.quarkus.launcher.shaded.\" does not match the host \"" + host + "io.quarkus.launcher.shaded.\"");
            }
            if (!domain.startsWith("io.quarkus.launcher.shaded..")) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + domain + "io.quarkus.launcher.shaded.\" violates RFC 2109: domain must start with a dot");
            }
            dotIndex = domain.indexOf(46, 1);
            if (dotIndex < 0 || dotIndex == domain.length() - 1) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + domain + "io.quarkus.launcher.shaded.\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (!(host = host.toLowerCase(Locale.ROOT)).endsWith(domain)) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Illegal domain attribute \"" + domain + "io.quarkus.launcher.shaded.\". Domain of origin: \"" + host + "io.quarkus.launcher.shaded.\"");
            }
            String hostWithoutDomain = host.substring(0, host.length() - domain.length());
            if (hostWithoutDomain.indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + domain + "io.quarkus.launcher.shaded.\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        return host.equals(domain) || domain.startsWith("io.quarkus.launcher.shaded..") && host.endsWith(domain);
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.domain";
    }
}

