/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HeaderElement;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Obsolete;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.ClientCookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookiePathComparator;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicCommentHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicExpiresHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicPathHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicSecureHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.CookieSpecBase;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2109DomainHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.RFC2109VersionHandler;
import io.quarkus.launcher.shaded.org.apache.http.message.BufferedHeader;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Obsolete
@Contract(threading=ThreadingBehavior.SAFE)
public class RFC2109Spec
extends CookieSpecBase {
    static final String[] DATE_PATTERNS = new String[]{"io.quarkus.launcher.shaded.EEE, dd MMM yyyy HH:mm:ss zzz", "io.quarkus.launcher.shaded.EEE, dd-MMM-yy HH:mm:ss zzz", "io.quarkus.launcher.shaded.EEE MMM d HH:mm:ss yyyy"};
    private final boolean oneHeader;

    public RFC2109Spec(String[] datepatterns, boolean oneHeader) {
        super(new RFC2109VersionHandler(), new BasicPathHandler(){

            @Override
            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                if (!this.match(cookie, origin)) {
                    throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Illegal 'path' attribute \"" + cookie.getPath() + "io.quarkus.launcher.shaded.\". Path of origin: \"" + origin.getPath() + "io.quarkus.launcher.shaded.\"");
                }
            }
        }, new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(datepatterns != null ? (String[])datepatterns.clone() : DATE_PATTERNS));
        this.oneHeader = oneHeader;
    }

    public RFC2109Spec() {
        this(null, false);
    }

    protected RFC2109Spec(boolean oneHeader, CommonCookieAttributeHandler ... handlers) {
        super(handlers);
        this.oneHeader = oneHeader;
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(header, "io.quarkus.launcher.shaded.Header");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        if (!header.getName().equalsIgnoreCase("io.quarkus.launcher.shaded.Set-Cookie")) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Unrecognized cookie header '" + header.toString() + "io.quarkus.launcher.shaded.'");
        }
        HeaderElement[] elems = header.getElements();
        return this.parse(elems, origin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        String name = cookie.getName();
        if (name.indexOf(32) != -1) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Cookie name may not contain blanks");
        }
        if (name.startsWith("io.quarkus.launcher.shaded.$")) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Cookie name may not start with $");
        }
        super.validate(cookie, origin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        List<Cookie> cookieList;
        Args.notEmpty(cookies, "io.quarkus.launcher.shaded.List of cookies");
        if (cookies.size() > 1) {
            cookieList = new ArrayList<Cookie>(cookies);
            Collections.sort(cookieList, CookiePathComparator.INSTANCE);
        } else {
            cookieList = cookies;
        }
        return this.oneHeader ? this.doFormatOneHeader(cookieList) : this.doFormatManyHeaders(cookieList);
    }

    private List<Header> doFormatOneHeader(List<Cookie> cookies) {
        int version = Integer.MAX_VALUE;
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        CharArrayBuffer buffer = new CharArrayBuffer(40 * cookies.size());
        buffer.append("io.quarkus.launcher.shaded.Cookie");
        buffer.append("io.quarkus.launcher.shaded.: ");
        buffer.append("io.quarkus.launcher.shaded.$Version=");
        buffer.append(Integer.toString(version));
        for (Cookie cooky : cookies) {
            buffer.append("io.quarkus.launcher.shaded.; ");
            Cookie cookie = cooky;
            this.formatCookieAsVer(buffer, cookie, version);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    private List<Header> doFormatManyHeaders(List<Cookie> cookies) {
        ArrayList<Header> headers = new ArrayList<Header>(cookies.size());
        for (Cookie cookie : cookies) {
            int version = cookie.getVersion();
            CharArrayBuffer buffer = new CharArrayBuffer(40);
            buffer.append("io.quarkus.launcher.shaded.Cookie: ");
            buffer.append("io.quarkus.launcher.shaded.$Version=");
            buffer.append(Integer.toString(version));
            buffer.append("io.quarkus.launcher.shaded.; ");
            this.formatCookieAsVer(buffer, cookie, version);
            headers.add(new BufferedHeader(buffer));
        }
        return headers;
    }

    protected void formatParamAsVer(CharArrayBuffer buffer, String name, String value, int version) {
        buffer.append(name);
        buffer.append("io.quarkus.launcher.shaded.=");
        if (value != null) {
            if (version > 0) {
                buffer.append('\"');
                buffer.append(value);
                buffer.append('\"');
            } else {
                buffer.append(value);
            }
        }
    }

    protected void formatCookieAsVer(CharArrayBuffer buffer, Cookie cookie, int version) {
        this.formatParamAsVer(buffer, cookie.getName(), cookie.getValue(), version);
        if (cookie.getPath() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("io.quarkus.launcher.shaded.path")) {
            buffer.append("io.quarkus.launcher.shaded.; ");
            this.formatParamAsVer(buffer, "io.quarkus.launcher.shaded.$Path", cookie.getPath(), version);
        }
        if (cookie.getDomain() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("io.quarkus.launcher.shaded.domain")) {
            buffer.append("io.quarkus.launcher.shaded.; ");
            this.formatParamAsVer(buffer, "io.quarkus.launcher.shaded.$Domain", cookie.getDomain(), version);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "io.quarkus.launcher.shaded.rfc2109";
    }
}

