/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.ClientCookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965DomainAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String domain) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (domain == null) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Missing value for domain attribute");
        }
        if (domain.trim().isEmpty()) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Blank value for domain attribute");
        }
        String s = domain;
        s = s.toLowerCase(Locale.ROOT);
        if (!domain.startsWith("io.quarkus.launcher.shaded..")) {
            s = '.' + s;
        }
        cookie.setDomain(s);
    }

    public boolean domainMatch(String host, String domain) {
        boolean match = host.equals(domain) || domain.startsWith("io.quarkus.launcher.shaded..") && host.endsWith(domain);
        return match;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost().toLowerCase(Locale.ROOT);
        if (cookie.getDomain() == null) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Invalid cookie state: domain not specified");
        }
        String cookieDomain = cookie.getDomain().toLowerCase(Locale.ROOT);
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("io.quarkus.launcher.shaded.domain")) {
            if (!cookieDomain.startsWith("io.quarkus.launcher.shaded..")) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + cookie.getDomain() + "io.quarkus.launcher.shaded.\" violates RFC 2109: domain must start with a dot");
            }
            int dotIndex = cookieDomain.indexOf(46, 1);
            if (!(dotIndex >= 0 && dotIndex != cookieDomain.length() - 1 || cookieDomain.equals("io.quarkus.launcher.shaded..local"))) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + cookie.getDomain() + "io.quarkus.launcher.shaded.\" violates RFC 2965: the value contains no embedded dots " + "io.quarkus.launcher.shaded.and the value is not .local");
            }
            if (!this.domainMatch(host, cookieDomain)) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + cookie.getDomain() + "io.quarkus.launcher.shaded.\" violates RFC 2965: effective host name does not " + "io.quarkus.launcher.shaded.domain-match domain attribute.");
            }
            String effectiveHostWithoutDomain = host.substring(0, host.length() - cookieDomain.length());
            if (effectiveHostWithoutDomain.indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Domain attribute \"" + cookie.getDomain() + "io.quarkus.launcher.shaded.\" violates RFC 2965: " + "io.quarkus.launcher.shaded.effective host minus domain may not contain any dots");
            }
        } else if (!cookie.getDomain().equals(host)) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Illegal domain attribute: \"" + cookie.getDomain() + "io.quarkus.launcher.shaded.\"." + "io.quarkus.launcher.shaded.Domain of origin: \"" + host + "io.quarkus.launcher.shaded.\"");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost().toLowerCase(Locale.ROOT);
        String cookieDomain = cookie.getDomain();
        if (!this.domainMatch(host, cookieDomain)) {
            return false;
        }
        String effectiveHostWithoutDomain = host.substring(0, host.length() - cookieDomain.length());
        return effectiveHostWithoutDomain.indexOf(46) == -1;
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.domain";
    }
}

