/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.ClientCookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie2;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (value == null) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("io.quarkus.launcher.shaded.version")) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.version";
    }
}

