/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.entity;

import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HeaderElement;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpMessage;
import io.quarkus.launcher.shaded.org.apache.http.ParseException;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.entity.ContentLengthStrategy;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public static final LaxContentLengthStrategy INSTANCE = new LaxContentLengthStrategy();
    private final int implicitLen;

    public LaxContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public LaxContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "io.quarkus.launcher.shaded.HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("io.quarkus.launcher.shaded.Transfer-Encoding");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings;
            try {
                encodings = transferEncodingHeader.getElements();
            }
            catch (ParseException px) {
                throw new ProtocolException("io.quarkus.launcher.shaded.Invalid Transfer-Encoding header value: " + transferEncodingHeader, px);
            }
            int len = encodings.length;
            if ("io.quarkus.launcher.shaded.identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -1L;
            }
            if (len > 0 && "io.quarkus.launcher.shaded.chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                return -2L;
            }
            return -1L;
        }
        Header contentLengthHeader = message.getFirstHeader("io.quarkus.launcher.shaded.Content-Length");
        if (contentLengthHeader != null) {
            long contentLen = -1L;
            Header[] headers = message.getHeaders("io.quarkus.launcher.shaded.Content-Length");
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    contentLen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
            }
            return contentLen >= 0L ? contentLen : -1L;
        }
        return this.implicitLen;
    }
}

