/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.entity;

import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpMessage;
import io.quarkus.launcher.shaded.org.apache.http.HttpVersion;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.entity.ContentLengthStrategy;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public static final StrictContentLengthStrategy INSTANCE = new StrictContentLengthStrategy();
    private final int implicitLen;

    public StrictContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public StrictContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "io.quarkus.launcher.shaded.HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("io.quarkus.launcher.shaded.Transfer-Encoding");
        if (transferEncodingHeader != null) {
            String s = transferEncodingHeader.getValue();
            if ("io.quarkus.launcher.shaded.chunked".equalsIgnoreCase(s)) {
                if (message.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("io.quarkus.launcher.shaded.Chunked transfer encoding not allowed for " + message.getProtocolVersion());
                }
                return -2L;
            }
            if ("io.quarkus.launcher.shaded.identity".equalsIgnoreCase(s)) {
                return -1L;
            }
            throw new ProtocolException("io.quarkus.launcher.shaded.Unsupported transfer encoding: " + s);
        }
        Header contentLengthHeader = message.getFirstHeader("io.quarkus.launcher.shaded.Content-Length");
        if (contentLengthHeader != null) {
            String s = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s);
                if (len < 0L) {
                    throw new ProtocolException("io.quarkus.launcher.shaded.Negative content length: " + s);
                }
                return len;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("io.quarkus.launcher.shaded.Invalid content length: " + s);
            }
        }
        return this.implicitLen;
    }
}

