/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.execchain;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScope;
import io.quarkus.launcher.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import io.quarkus.launcher.shaded.org.apache.http.client.CredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpExecutionAware;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpRequestWrapper;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpUriRequest;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.client.utils.URIUtils;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.HttpRoute;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.impl.execchain.ClientExecChain;
import io.quarkus.launcher.shaded.org.apache.http.params.HttpParams;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpProcessor;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain requestExecutor, HttpProcessor httpProcessor) {
        Args.notNull(requestExecutor, "io.quarkus.launcher.shaded.HTTP client request executor");
        Args.notNull(httpProcessor, "io.quarkus.launcher.shaded.HTTP protocol processor");
        this.requestExecutor = requestExecutor;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route, boolean normalizeUri) throws ProtocolException {
        URI uri = request.getURI();
        if (uri != null) {
            try {
                request.setURI(URIUtils.rewriteURIForRoute(uri, route, normalizeUri));
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("io.quarkus.launcher.shaded.Invalid URI: " + uri, ex);
            }
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        String userinfo;
        URI uri;
        block18: {
            Args.notNull(route, "io.quarkus.launcher.shaded.HTTP route");
            Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
            Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
            HttpRequest original = request.getOriginal();
            uri = null;
            if (original instanceof HttpUriRequest) {
                uri = ((HttpUriRequest)original).getURI();
            } else {
                String uriString = original.getRequestLine().getUri();
                try {
                    uri = URI.create(uriString);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.debug("io.quarkus.launcher.shaded.Unable to parse '" + uriString + "io.quarkus.launcher.shaded.' as a valid URI; " + "io.quarkus.launcher.shaded.request URI and Host header may be inconsistent", ex);
                }
            }
        }
        request.setURI(uri);
        this.rewriteRequestURI(request, route, context.getRequestConfig().isNormalizeUri());
        HttpParams params = request.getParams();
        HttpHost virtualHost = (HttpHost)params.getParameter("io.quarkus.launcher.shaded.http.virtual-host");
        if (virtualHost != null && virtualHost.getPort() == -1) {
            int port = route.getTargetHost().getPort();
            if (port != -1) {
                virtualHost = new HttpHost(virtualHost.getHostName(), port, virtualHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Using virtual host" + virtualHost);
            }
        }
        HttpHost target = null;
        if (virtualHost != null) {
            target = virtualHost;
        } else if (uri != null && uri.isAbsolute() && uri.getHost() != null) {
            target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        if (target == null) {
            target = request.getTarget();
        }
        if (target == null) {
            target = route.getTargetHost();
        }
        if (uri != null && (userinfo = uri.getUserInfo()) != null) {
            CredentialsProvider credsProvider = context.getCredentialsProvider();
            if (credsProvider == null) {
                credsProvider = new BasicCredentialsProvider();
                context.setCredentialsProvider(credsProvider);
            }
            credsProvider.setCredentials(new AuthScope(target), new UsernamePasswordCredentials(userinfo));
        }
        context.setAttribute("io.quarkus.launcher.shaded.http.target_host", target);
        context.setAttribute("io.quarkus.launcher.shaded.http.route", route);
        context.setAttribute("io.quarkus.launcher.shaded.http.request", request);
        this.httpProcessor.process(request, (HttpContext)context);
        CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
        try {
            context.setAttribute("io.quarkus.launcher.shaded.http.response", response);
            this.httpProcessor.process(response, (HttpContext)context);
            return response;
        }
        catch (RuntimeException ex) {
            response.close();
            throw ex;
        }
        catch (IOException ex) {
            response.close();
            throw ex;
        }
        catch (HttpException ex) {
            response.close();
            throw ex;
        }
    }
}

