/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.execchain;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.NoHttpResponseException;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.HttpRequestRetryHandler;
import io.quarkus.launcher.shaded.org.apache.http.client.NonRepeatableRequestException;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpExecutionAware;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpRequestWrapper;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.HttpRoute;
import io.quarkus.launcher.shaded.org.apache.http.impl.execchain.ClientExecChain;
import io.quarkus.launcher.shaded.org.apache.http.impl.execchain.RequestEntityProxy;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain requestExecutor, HttpRequestRetryHandler retryHandler) {
        Args.notNull(requestExecutor, "io.quarkus.launcher.shaded.HTTP request executor");
        Args.notNull(retryHandler, "io.quarkus.launcher.shaded.HTTP request retry handler");
        this.requestExecutor = requestExecutor;
        this.retryHandler = retryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "io.quarkus.launcher.shaded.HTTP route");
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        Header[] origheaders = request.getAllHeaders();
        int execCount = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(route, request, context, execAware);
            }
            catch (IOException ex) {
                if (execAware != null && execAware.isAborted()) {
                    this.log.debug("io.quarkus.launcher.shaded.Request has been aborted");
                    throw ex;
                }
                if (this.retryHandler.retryRequest(ex, execCount, context)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("io/quarkus/launcher/shaded/I/O exception (" + ex.getClass().getName() + "io.quarkus.launcher.shaded.) caught when processing request to " + route + "io.quarkus.launcher.shaded.: " + ex.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ex.getMessage(), ex);
                    }
                    if (!RequestEntityProxy.isRepeatable(request)) {
                        this.log.debug("io.quarkus.launcher.shaded.Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("io.quarkus.launcher.shaded.Cannot retry request with a non-repeatable request entity", ex);
                    }
                    request.setHeaders(origheaders);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("io.quarkus.launcher.shaded.Retrying request to " + route);
                    }
                } else {
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route.getTargetHost().toHostString() + "io.quarkus.launcher.shaded. failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                ++execCount;
                continue;
            }
            break;
        }
    }
}

