/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.protocol;

import io.quarkus.launcher.shaded.org.apache.http.HttpConnection;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.protocol.BasicHttpContext;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

public class HttpCoreContext
implements HttpContext {
    public static final String HTTP_CONNECTION = "io.quarkus.launcher.shaded.http.connection";
    public static final String HTTP_REQUEST = "io.quarkus.launcher.shaded.http.request";
    public static final String HTTP_RESPONSE = "io.quarkus.launcher.shaded.http.response";
    public static final String HTTP_TARGET_HOST = "io.quarkus.launcher.shaded.http.target_host";
    public static final String HTTP_REQ_SENT = "io.quarkus.launcher.shaded.http.request_sent";
    private final HttpContext context;

    public static HttpCoreContext create() {
        return new HttpCoreContext(new BasicHttpContext());
    }

    public static HttpCoreContext adapt(HttpContext context) {
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        return context instanceof HttpCoreContext ? (HttpCoreContext)context : new HttpCoreContext(context);
    }

    public HttpCoreContext(HttpContext context) {
        this.context = context;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    @Override
    public Object getAttribute(String id) {
        return this.context.getAttribute(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.context.setAttribute(id, obj);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.context.removeAttribute(id);
    }

    public <T> T getAttribute(String attribname, Class<T> clazz) {
        Args.notNull(clazz, "io.quarkus.launcher.shaded.Attribute class");
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return clazz.cast(obj);
    }

    public <T extends HttpConnection> T getConnection(Class<T> clazz) {
        return (T)((HttpConnection)this.getAttribute(HTTP_CONNECTION, clazz));
    }

    public HttpConnection getConnection() {
        return this.getAttribute(HTTP_CONNECTION, HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute(HTTP_REQUEST, HttpRequest.class);
    }

    public boolean isRequestSent() {
        Boolean b = this.getAttribute(HTTP_REQ_SENT, Boolean.class);
        return b != null && b != false;
    }

    public HttpResponse getResponse() {
        return this.getAttribute(HTTP_RESPONSE, HttpResponse.class);
    }

    public void setTargetHost(HttpHost host) {
        this.setAttribute(HTTP_TARGET_HOST, host);
    }

    public HttpHost getTargetHost() {
        return this.getAttribute(HTTP_TARGET_HOST, HttpHost.class);
    }
}

