/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.protocol;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@Contract(threading=ThreadingBehavior.SAFE)
public class HttpDateGenerator {
    public static final String PATTERN_RFC1123 = "io.quarkus.launcher.shaded.EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final TimeZone GMT = TimeZone.getTimeZone("io.quarkus.launcher.shaded.GMT");
    private final DateFormat dateformat = new SimpleDateFormat("io.quarkus.launcher.shaded.EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private long dateAsLong = 0L;
    private String dateAsText = null;

    public HttpDateGenerator() {
        this.dateformat.setTimeZone(GMT);
    }

    public synchronized String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now - this.dateAsLong > 1000L) {
            this.dateAsText = this.dateformat.format(new Date(now));
            this.dateAsLong = now;
        }
        return this.dateAsText;
    }
}

