/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.protocol;

import io.quarkus.launcher.shaded.org.apache.http.HttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.HttpEntityEnclosingRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequestInterceptor;
import io.quarkus.launcher.shaded.org.apache.http.HttpVersion;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolVersion;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestContent
implements HttpRequestInterceptor {
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        if (request instanceof HttpEntityEnclosingRequest) {
            if (this.overwrite) {
                request.removeHeaders("io.quarkus.launcher.shaded.Transfer-Encoding");
                request.removeHeaders("io.quarkus.launcher.shaded.Content-Length");
            } else {
                if (request.containsHeader("io.quarkus.launcher.shaded.Transfer-Encoding")) {
                    throw new ProtocolException("io.quarkus.launcher.shaded.Transfer-encoding header already present");
                }
                if (request.containsHeader("io.quarkus.launcher.shaded.Content-Length")) {
                    throw new ProtocolException("io.quarkus.launcher.shaded.Content-Length header already present");
                }
            }
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity == null) {
                request.addHeader("io.quarkus.launcher.shaded.Content-Length", "io.quarkus.launcher.shaded.0");
                return;
            }
            if (entity.isChunked() || entity.getContentLength() < 0L) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("io.quarkus.launcher.shaded.Chunked transfer encoding not allowed for " + ver);
                }
                request.addHeader("io.quarkus.launcher.shaded.Transfer-Encoding", "io.quarkus.launcher.shaded.chunked");
            } else {
                request.addHeader("io.quarkus.launcher.shaded.Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !request.containsHeader("io.quarkus.launcher.shaded.Content-Type")) {
                request.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !request.containsHeader("io.quarkus.launcher.shaded.Content-Encoding")) {
                request.addHeader(entity.getContentEncoding());
            }
        }
    }
}

