/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.protocol;

import io.quarkus.launcher.shaded.org.apache.http.HttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponseInterceptor;
import io.quarkus.launcher.shaded.org.apache.http.HttpVersion;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolVersion;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseContent
implements HttpResponseInterceptor {
    private final boolean overwrite;

    public ResponseContent() {
        this(false);
    }

    public ResponseContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        if (this.overwrite) {
            response.removeHeaders("io.quarkus.launcher.shaded.Transfer-Encoding");
            response.removeHeaders("io.quarkus.launcher.shaded.Content-Length");
        } else {
            if (response.containsHeader("io.quarkus.launcher.shaded.Transfer-Encoding")) {
                throw new ProtocolException("io.quarkus.launcher.shaded.Transfer-encoding header already present");
            }
            if (response.containsHeader("io.quarkus.launcher.shaded.Content-Length")) {
                throw new ProtocolException("io.quarkus.launcher.shaded.Content-Length header already present");
            }
        }
        ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long len = entity.getContentLength();
            if (entity.isChunked() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                response.addHeader("io.quarkus.launcher.shaded.Transfer-Encoding", "io.quarkus.launcher.shaded.chunked");
            } else if (len >= 0L) {
                response.addHeader("io.quarkus.launcher.shaded.Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !response.containsHeader("io.quarkus.launcher.shaded.Content-Type")) {
                response.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !response.containsHeader("io.quarkus.launcher.shaded.Content-Encoding")) {
                response.addHeader(entity.getContentEncoding());
            }
        } else {
            int status = response.getStatusLine().getStatusCode();
            if (status != 204 && status != 304 && status != 205) {
                response.addHeader("io.quarkus.launcher.shaded.Content-Length", "io.quarkus.launcher.shaded.0");
            }
        }
    }
}

