/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.ArtifactFilterManager;
import io.quarkus.launcher.shaded.org.apache.maven.ArtifactFilterManagerDelegate;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;
import io.quarkus.launcher.shaded.org.apache.maven.extension.internal.CoreExportsProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Named
@Singleton
public class DefaultArtifactFilterManager
implements ArtifactFilterManager {
    protected final List<ArtifactFilterManagerDelegate> delegates;
    protected Set<String> excludedArtifacts;
    private final Set<String> coreArtifacts;

    @Inject
    public DefaultArtifactFilterManager(List<ArtifactFilterManagerDelegate> delegates, CoreExportsProvider coreExports) {
        this.delegates = delegates;
        this.coreArtifacts = coreExports.get().getExportedArtifacts();
    }

    private synchronized Set<String> getExcludedArtifacts() {
        if (this.excludedArtifacts == null) {
            this.excludedArtifacts = new LinkedHashSet<String>(this.coreArtifacts);
        }
        return this.excludedArtifacts;
    }

    @Override
    public ArtifactFilter getArtifactFilter() {
        LinkedHashSet<String> excludes = new LinkedHashSet<String>(this.getExcludedArtifacts());
        for (ArtifactFilterManagerDelegate delegate : this.delegates) {
            delegate.addExcludes(excludes);
        }
        return new ExclusionSetFilter(excludes);
    }

    @Override
    public ArtifactFilter getCoreArtifactFilter() {
        return new ExclusionSetFilter(this.getCoreArtifactExcludes());
    }

    @Override
    public void excludeArtifact(String artifactId) {
        this.getExcludedArtifacts().add(artifactId);
    }

    @Override
    public Set<String> getCoreArtifactExcludes() {
        LinkedHashSet<String> excludes = new LinkedHashSet<String>(this.coreArtifacts);
        for (ArtifactFilterManagerDelegate delegate : this.delegates) {
            delegate.addCoreExcludes(excludes);
        }
        return excludes;
    }
}

