/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven;

import io.quarkus.launcher.shaded.org.apache.maven.ProjectDependenciesResolver;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.ArtifactUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.artifact.ProjectArtifact;
import io.quarkus.launcher.shaded.org.apache.maven.repository.RepositorySystem;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Deprecated
@Component(role=ProjectDependenciesResolver.class)
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;

    @Override
    public Set<Artifact> resolve(MavenProject project, Collection<String> scopesToResolve, MavenSession session) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolve(Collections.singleton(project), scopesToResolve, session);
    }

    @Override
    public Set<Artifact> resolve(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session) throws ArtifactResolutionException, ArtifactNotFoundException {
        Set<MavenProject> mavenProjects = Collections.singleton(project);
        return this.resolveImpl(mavenProjects, scopesToCollect, scopesToResolve, session, this.getIgnorableArtifacts((Collection<? extends MavenProject>)mavenProjects));
    }

    @Override
    public Set<Artifact> resolve(Collection<? extends MavenProject> projects, Collection<String> scopesToResolve, MavenSession session) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveImpl(projects, null, scopesToResolve, session, this.getIgnorableArtifacts(projects));
    }

    @Override
    public Set<Artifact> resolve(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, Set<Artifact> ignoreableArtifacts) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveImpl(Collections.singleton(project), scopesToCollect, scopesToResolve, session, this.getIgnorableArtifacts((Iterable<Artifact>)ignoreableArtifacts));
    }

    private Set<Artifact> resolveImpl(Collection<? extends MavenProject> projects, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, Set<String> projectIds) throws ArtifactResolutionException, ArtifactNotFoundException {
        LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
        if (projects == null || projects.isEmpty()) {
            return resolved;
        }
        if ((scopesToCollect == null || scopesToCollect.isEmpty()) && (scopesToResolve == null || scopesToResolve.isEmpty())) {
            return resolved;
        }
        CumulativeScopeArtifactFilter resolutionScopeFilter = new CumulativeScopeArtifactFilter(scopesToResolve);
        CumulativeScopeArtifactFilter collectionScopeFilter = new CumulativeScopeArtifactFilter(scopesToCollect);
        collectionScopeFilter = new CumulativeScopeArtifactFilter(collectionScopeFilter, resolutionScopeFilter);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setResolveRoot(false).setResolveTransitively(true).setCollectionFilter(collectionScopeFilter).setResolutionFilter(resolutionScopeFilter).setLocalRepository(session.getLocalRepository()).setOffline(session.isOffline()).setForceUpdate(session.getRequest().isUpdateSnapshots());
        request.setServers(session.getRequest().getServers());
        request.setMirrors(session.getRequest().getMirrors());
        request.setProxies(session.getRequest().getProxies());
        for (MavenProject mavenProject : projects) {
            ArtifactResolutionResult result;
            block6: {
                request.setArtifact(new ProjectArtifact(mavenProject));
                request.setArtifactDependencies(mavenProject.getDependencyArtifacts());
                request.setManagedVersionMap(mavenProject.getManagedVersionMap());
                request.setRemoteRepositories((List)mavenProject.getRemoteArtifactRepositories());
                result = this.repositorySystem.resolve(request);
                try {
                    this.resolutionErrorHandler.throwErrors(request, result);
                }
                catch (MultipleArtifactsNotFoundException e) {
                    HashSet<Artifact> missing = new HashSet<Artifact>(e.getMissingArtifacts());
                    Iterator it = missing.iterator();
                    while (it.hasNext()) {
                        String key = ArtifactUtils.key((Artifact)it.next());
                        if (!projectIds.contains(key)) continue;
                        it.remove();
                    }
                    if (missing.isEmpty()) break block6;
                    throw e;
                }
            }
            resolved.addAll(result.getArtifacts());
        }
        return resolved;
    }

    private Set<String> getIgnorableArtifacts(Collection<? extends MavenProject> projects) {
        HashSet<String> projectIds = new HashSet<String>(projects.size() * 2);
        for (MavenProject mavenProject : projects) {
            String key = ArtifactUtils.key(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
            projectIds.add(key);
        }
        return projectIds;
    }

    private Set<String> getIgnorableArtifacts(Iterable<Artifact> artifactIterable) {
        HashSet<String> projectIds = new HashSet<String>();
        for (Artifact artifact : artifactIterable) {
            String key = ArtifactUtils.key(artifact);
            projectIds.add(key);
        }
        return projectIds;
    }
}

