/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.SessionScoped;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.ArtifactUtils;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.MavenWorkspaceReader;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.WorkspaceRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.artifact.ArtifactIdUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Named(value="io.quarkus.launcher.shaded.reactor")
@SessionScoped
class ReactorReader
implements MavenWorkspaceReader {
    public static final String HINT = "io.quarkus.launcher.shaded.reactor";
    private static final Collection<String> COMPILE_PHASE_TYPES = Arrays.asList("io.quarkus.launcher.shaded.jar", "io.quarkus.launcher.shaded.ejb-client", "io.quarkus.launcher.shaded.war", "io.quarkus.launcher.shaded.rar", "io.quarkus.launcher.shaded.ejb3", "io.quarkus.launcher.shaded.par", "io.quarkus.launcher.shaded.sar", "io.quarkus.launcher.shaded.wsr", "io.quarkus.launcher.shaded.har", "io.quarkus.launcher.shaded.app-client");
    private Map<String, MavenProject> projectsByGAV;
    private Map<String, List<MavenProject>> projectsByGA;
    private WorkspaceRepository repository;

    @Inject
    ReactorReader(MavenSession session) {
        this.projectsByGAV = session.getProjectMap();
        this.projectsByGA = new HashMap<String, List<MavenProject>>(this.projectsByGAV.size() * 2);
        for (MavenProject project : this.projectsByGAV.values()) {
            String key = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            List<MavenProject> projects = this.projectsByGA.get(key);
            if (projects == null) {
                projects = new ArrayList<MavenProject>(1);
                this.projectsByGA.put(key, projects);
            }
            projects.add(project);
        }
        this.repository = new WorkspaceRepository(HINT, new HashSet<String>(this.projectsByGAV.keySet()));
    }

    @Override
    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    @Override
    public File findArtifact(Artifact artifact) {
        String projectKey = ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project = this.projectsByGAV.get(projectKey);
        if (project != null) {
            File file = this.find(project, artifact);
            if (file == null && project != project.getExecutionProject()) {
                file = this.find(project.getExecutionProject(), artifact);
            }
            return file;
        }
        return null;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        String key = ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        List<MavenProject> projects = this.projectsByGA.get(key);
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (MavenProject project : projects) {
            if (this.find(project, artifact) == null) continue;
            versions.add(project.getVersion());
        }
        return Collections.unmodifiableList(versions);
    }

    @Override
    public Model findModel(Artifact artifact) {
        String projectKey = ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project = this.projectsByGAV.get(projectKey);
        return project == null ? null : project.getModel();
    }

    private File find(MavenProject project, Artifact artifact) {
        if ("io.quarkus.launcher.shaded.pom".equals(artifact.getExtension())) {
            return project.getFile();
        }
        Artifact projectArtifact = this.findMatchingArtifact(project, artifact);
        if (this.hasArtifactFileFromPackagePhase(projectArtifact)) {
            return projectArtifact.getFile();
        }
        if (!this.hasBeenPackaged(project)) {
            if (ReactorReader.isTestArtifact(artifact)) {
                if (project.hasLifecyclePhase("io.quarkus.launcher.shaded.test-compile")) {
                    return new File(project.getBuild().getTestOutputDirectory());
                }
            } else {
                String type = artifact.getProperty("io.quarkus.launcher.shaded.type", "io.quarkus.launcher.shaded.");
                if (project.hasLifecyclePhase("io.quarkus.launcher.shaded.compile") && COMPILE_PHASE_TYPES.contains(type)) {
                    return new File(project.getBuild().getOutputDirectory());
                }
            }
        }
        return null;
    }

    private boolean hasArtifactFileFromPackagePhase(Artifact projectArtifact) {
        return projectArtifact != null && projectArtifact.getFile() != null && projectArtifact.getFile().exists();
    }

    private boolean hasBeenPackaged(MavenProject project) {
        return project.hasLifecyclePhase("io.quarkus.launcher.shaded.package") || project.hasLifecyclePhase("io.quarkus.launcher.shaded.install") || project.hasLifecyclePhase("io.quarkus.launcher.shaded.deploy");
    }

    private Artifact findMatchingArtifact(MavenProject project, Artifact requestedArtifact) {
        Artifact mainArtifact;
        String requestedRepositoryConflictId = ArtifactIdUtils.toVersionlessId(requestedArtifact);
        if (requestedRepositoryConflictId.equals(ArtifactIdUtils.toVersionlessId(mainArtifact = RepositoryUtils.toArtifact(project.getArtifact())))) {
            return mainArtifact;
        }
        for (Artifact attachedArtifact : RepositoryUtils.toArtifacts(project.getAttachedArtifacts())) {
            if (!this.attachedArtifactComparison(requestedArtifact, attachedArtifact)) continue;
            return attachedArtifact;
        }
        return null;
    }

    private boolean attachedArtifactComparison(Artifact requested, Artifact attached) {
        return requested.getArtifactId().equals(attached.getArtifactId()) && requested.getGroupId().equals(attached.getGroupId()) && requested.getVersion().equals(attached.getVersion()) && requested.getExtension().equals(attached.getExtension()) && requested.getClassifier().equals(attached.getClassifier());
    }

    private static boolean isTestArtifact(Artifact artifact) {
        return "io.quarkus.launcher.shaded.test-jar".equals(artifact.getProperty("io.quarkus.launcher.shaded.type", "io.quarkus.launcher.shaded.")) || "io.quarkus.launcher.shaded.jar".equals(artifact.getExtension()) && "io.quarkus.launcher.shaded.tests".equals(artifact.getClassifier());
    }
}

