/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.factory;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.factory.ArtifactFactory;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.ArtifactHandler;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.VersionRange;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactFactory.class)
public class DefaultArtifactFactory
implements ArtifactFactory {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.createArtifact(groupId, artifactId, version, scope, type, null, null);
    }

    @Override
    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.createArtifact(groupId, artifactId, version, null, type, classifier, null);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, null);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, optional);
    }

    @Override
    public Artifact createBuildArtifact(String groupId, String artifactId, String version, String packaging) {
        return this.createArtifact(groupId, artifactId, version, null, packaging, null, null);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String version) {
        return this.createProjectArtifact(groupId, artifactId, version, null);
    }

    @Override
    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.createProjectArtifact(groupId, artifactId, version);
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifact(groupId, artifactId, versionRange, "io.quarkus.launcher.shaded.maven-plugin", null, "io.quarkus.launcher.shaded.runtime", null);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String version, String scope) {
        return this.createArtifact(groupId, artifactId, version, scope, "io.quarkus.launcher.shaded.pom");
    }

    @Override
    public Artifact createExtensionArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifact(groupId, artifactId, versionRange, "io.quarkus.launcher.shaded.jar", null, "io.quarkus.launcher.shaded.runtime", null);
    }

    private Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier, String inheritedScope) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion(version);
        }
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, false);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "io.quarkus.launcher.shaded.runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("io.quarkus.launcher.shaded.test".equals(scope) || "io.quarkus.launcher.shaded.provided".equals(scope)) {
                return null;
            }
            if ("io.quarkus.launcher.shaded.compile".equals(scope) && "io.quarkus.launcher.shaded.compile".equals(inheritedScope)) {
                desiredScope = "io.quarkus.launcher.shaded.compile";
            }
        }
        if ("io.quarkus.launcher.shaded.test".equals(inheritedScope)) {
            desiredScope = "io.quarkus.launcher.shaded.test";
        }
        if ("io.quarkus.launcher.shaded.provided".equals(inheritedScope)) {
            desiredScope = "io.quarkus.launcher.shaded.provided";
        }
        if ("io.quarkus.launcher.shaded.system".equals(scope)) {
            desiredScope = "io.quarkus.launcher.shaded.system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type, classifier, handler, optional);
    }
}

