/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.manager;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.ArtifactHandler;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.DefaultArtifactHandler;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component(role=ArtifactHandlerManager.class)
public class DefaultArtifactHandlerManager
implements ArtifactHandlerManager {
    @Requirement(role=ArtifactHandler.class)
    private Map<String, ArtifactHandler> artifactHandlers;
    private Map<String, ArtifactHandler> allHandlers = new ConcurrentHashMap<String, ArtifactHandler>();

    @Override
    public ArtifactHandler getArtifactHandler(String type) {
        ArtifactHandler handler = this.allHandlers.get(type);
        if (handler == null) {
            handler = this.artifactHandlers.get(type);
            if (handler == null) {
                handler = new DefaultArtifactHandler(type);
            } else {
                this.allHandlers.put(type, handler);
            }
        }
        return handler;
    }

    @Override
    public void addHandlers(Map<String, ArtifactHandler> handlers) {
        this.allHandlers.putAll(handlers);
    }

    @Deprecated
    public Set<String> getHandlerTypes() {
        return this.artifactHandlers.keySet();
    }
}

