/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.repository;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.metadata.ArtifactMetadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.Authentication;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import io.quarkus.launcher.shaded.org.apache.maven.repository.Proxy;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MavenArtifactRepository
implements ArtifactRepository {
    private String id;
    private String url;
    private String basedir;
    private String protocol;
    private ArtifactRepositoryLayout layout;
    private ArtifactRepositoryPolicy snapshots;
    private ArtifactRepositoryPolicy releases;
    private Authentication authentication;
    private Proxy proxy;
    private List<ArtifactRepository> mirroredRepositories = Collections.emptyList();

    public MavenArtifactRepository() {
    }

    public MavenArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        this.id = id;
        this.url = url;
        this.layout = layout;
        this.snapshots = snapshots;
        this.releases = releases;
        this.protocol = MavenArtifactRepository.protocol(url);
        this.basedir = this.basedir(url);
    }

    @Override
    public String pathOf(Artifact artifact) {
        return this.layout.pathOf(artifact);
    }

    @Override
    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata artifactMetadata) {
        return this.layout.pathOfRemoteRepositoryMetadata(artifactMetadata);
    }

    @Override
    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.layout.pathOfLocalRepositoryMetadata(metadata, repository);
    }

    @Override
    public void setLayout(ArtifactRepositoryLayout layout) {
        this.layout = layout;
    }

    @Override
    public ArtifactRepositoryLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy snapshots) {
        this.snapshots = snapshots;
    }

    @Override
    public ArtifactRepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy releases) {
        this.releases = releases;
    }

    @Override
    public ArtifactRepositoryPolicy getReleases() {
        return this.releases;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("io.quarkus.launcher.shaded.      id: ").append(this.getId()).append('\n');
        sb.append("io.quarkus.launcher.shaded.      url: ").append(this.getUrl()).append('\n');
        sb.append("io.quarkus.launcher.shaded.   layout: ").append(this.layout != null ? this.layout : "io.quarkus.launcher.shaded.none").append('\n');
        if (this.proxy != null) {
            sb.append("io.quarkus.launcher.shaded.    proxy: ").append(this.proxy.getHost()).append(':').append(this.proxy.getPort()).append('\n');
        }
        if (this.snapshots != null) {
            sb.append("io.quarkus.launcher.shaded.snapshots: [enabled => ").append(this.snapshots.isEnabled());
            sb.append("io.quarkus.launcher.shaded., update => ").append(this.snapshots.getUpdatePolicy()).append("io.quarkus.launcher.shaded.]\n");
        }
        if (this.releases != null) {
            sb.append("io.quarkus.launcher.shaded. releases: [enabled => ").append(this.releases.isEnabled());
            sb.append("io.quarkus.launcher.shaded., update => ").append(this.releases.getUpdatePolicy()).append("io.quarkus.launcher.shaded.]\n");
        }
        return sb.toString();
    }

    @Override
    public Artifact find(Artifact artifact) {
        File artifactFile = new File(this.getBasedir(), this.pathOf(artifact));
        artifact.setFile(artifactFile);
        return artifact;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getBasedir() {
        return this.basedir;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.protocol = MavenArtifactRepository.protocol(url);
        this.basedir = this.basedir(url);
    }

    private static String protocol(String url) {
        int pos = url.indexOf(58);
        if (pos == -1) {
            return "io.quarkus.launcher.shaded.";
        }
        return url.substring(0, pos).trim();
    }

    private String basedir(String url) {
        String retValue = null;
        if (this.protocol.equalsIgnoreCase("io.quarkus.launcher.shaded.file")) {
            retValue = url.substring(this.protocol.length() + 1);
            if ((retValue = MavenArtifactRepository.decode(retValue)).startsWith("io/quarkus/launcher/shaded///")) {
                if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + "io.quarkus.launcher.shaded.:" + retValue.substring(2);
                } else {
                    int index = retValue.indexOf(47);
                    if (index >= 0) {
                        retValue = retValue.substring(index + 1);
                    }
                    if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                        retValue = retValue.charAt(0) + "io.quarkus.launcher.shaded.:" + retValue.substring(2);
                    } else if (index >= 0) {
                        retValue = "io/quarkus/launcher/shaded//" + retValue;
                    }
                }
            }
            if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
                retValue = retValue.charAt(0) + "io.quarkus.launcher.shaded.:" + retValue.substring(2);
            }
            retValue = new File(retValue).getPath();
        }
        if (retValue == null) {
            retValue = "io/quarkus/launcher/shaded//";
        }
        return retValue.trim();
    }

    private static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos = -1;
            while ((pos = decoded.indexOf(37, pos + 1)) >= 0) {
                if (pos + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos + 1, pos + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos) + ch + decoded.substring(pos + 3);
            }
        }
        return decoded;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactRepository other = (ArtifactRepository)obj;
        return MavenArtifactRepository.eq(this.getId(), other.getId());
    }

    protected static <T> boolean eq(T s1, T s2) {
        return Objects.equals(s1, s2);
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public boolean isBlacklisted() {
        return false;
    }

    @Override
    public void setBlacklisted(boolean blackListed) {
    }

    @Override
    public boolean isUniqueVersion() {
        return true;
    }

    @Override
    public boolean isProjectAware() {
        return false;
    }

    @Override
    public List<ArtifactRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    @Override
    public void setMirroredRepositories(List<ArtifactRepository> mirroredRepositories) {
        this.mirroredRepositories = mirroredRepositories != null ? Collections.unmodifiableList(mirroredRepositories) : Collections.emptyList();
    }
}

