/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.io.xpp3;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Snapshot;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.metadata.Versioning;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.MXSerializer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class MetadataXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Metadata metadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "io.quarkus.launcher.shaded.  ");
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "io.quarkus.launcher.shaded.\n");
        serializer.setOutput(writer);
        serializer.startDocument(metadata.getModelEncoding(), null);
        this.writeMetadata(metadata, "io.quarkus.launcher.shaded.metadata", serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Metadata metadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "io.quarkus.launcher.shaded.  ");
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "io.quarkus.launcher.shaded.\n");
        serializer.setOutput(stream, metadata.getModelEncoding());
        serializer.startDocument(metadata.getModelEncoding(), null);
        this.writeMetadata(metadata, "io.quarkus.launcher.shaded.metadata", serializer);
        serializer.endDocument();
    }

    private void writeMetadata(Metadata metadata, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (metadata.getModelVersion() != null) {
            serializer.attribute(NAMESPACE, "io.quarkus.launcher.shaded.modelVersion", metadata.getModelVersion());
        }
        if (metadata.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId").text(metadata.getGroupId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.groupId");
        }
        if (metadata.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(metadata.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
        }
        if (metadata.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(metadata.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
        }
        if (metadata.getVersioning() != null) {
            this.writeVersioning(metadata.getVersioning(), "io.quarkus.launcher.shaded.versioning", serializer);
        }
        if (metadata.getPlugins() != null && metadata.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
            for (Plugin o : metadata.getPlugins()) {
                this.writePlugin(o, "io.quarkus.launcher.shaded.plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (plugin.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(plugin.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
        }
        if (plugin.getPrefix() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.prefix").text(plugin.getPrefix()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.prefix");
        }
        if (plugin.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId").text(plugin.getArtifactId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.artifactId");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSnapshot(Snapshot snapshot, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (snapshot.getTimestamp() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.timestamp").text(snapshot.getTimestamp()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.timestamp");
        }
        if (snapshot.getBuildNumber() != 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.buildNumber").text(String.valueOf(snapshot.getBuildNumber())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.buildNumber");
        }
        if (snapshot.isLocalCopy()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.localCopy").text(String.valueOf(snapshot.isLocalCopy())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.localCopy");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSnapshotVersion(SnapshotVersion snapshotVersion, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (snapshotVersion.getClassifier() != null && !snapshotVersion.getClassifier().equals("io.quarkus.launcher.shaded.")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.classifier").text(snapshotVersion.getClassifier()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.classifier");
        }
        if (snapshotVersion.getExtension() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.extension").text(snapshotVersion.getExtension()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.extension");
        }
        if (snapshotVersion.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.value").text(snapshotVersion.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.value");
        }
        if (snapshotVersion.getUpdated() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.updated").text(snapshotVersion.getUpdated()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.updated");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeVersioning(Versioning versioning, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (versioning.getLatest() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.latest").text(versioning.getLatest()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.latest");
        }
        if (versioning.getRelease() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.release").text(versioning.getRelease()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.release");
        }
        if (versioning.getSnapshot() != null) {
            this.writeSnapshot(versioning.getSnapshot(), "io.quarkus.launcher.shaded.snapshot", serializer);
        }
        if (versioning.getVersions() != null && versioning.getVersions().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.versions");
            for (String version : versioning.getVersions()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(version).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.versions");
        }
        if (versioning.getLastUpdated() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.lastUpdated").text(versioning.getLastUpdated()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.lastUpdated");
        }
        if (versioning.getSnapshotVersions() != null && versioning.getSnapshotVersions().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.snapshotVersions");
            for (SnapshotVersion o : versioning.getSnapshotVersions()) {
                this.writeSnapshotVersion(o, "io.quarkus.launcher.shaded.snapshotVersion", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.snapshotVersions");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

