/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component(role=ResolutionErrorHandler.class)
public class DefaultResolutionErrorHandler
implements ResolutionErrorHandler {
    @Override
    public void throwErrors(ArtifactResolutionRequest request, ArtifactResolutionResult result) throws ArtifactResolutionException {
        if (result.hasMetadataResolutionExceptions()) {
            throw result.getMetadataResolutionException(0);
        }
        if (result.hasCircularDependencyExceptions()) {
            throw result.getCircularDependencyException(0);
        }
        if (result.hasVersionRangeViolations()) {
            throw result.getVersionRangeViolation(0);
        }
        if (result.hasErrorArtifactExceptions()) {
            throw result.getErrorArtifactExceptions().get(0);
        }
        if (result.hasMissingArtifacts()) {
            throw new MultipleArtifactsNotFoundException(request.getArtifact(), DefaultResolutionErrorHandler.toList(result.getArtifacts()), result.getMissingArtifacts(), request.getRemoteRepositories());
        }
        if (result.hasExceptions()) {
            throw new ArtifactResolutionException("io.quarkus.launcher.shaded.Unknown error during artifact resolution, " + request + "io.quarkus.launcher.shaded., " + result.getExceptions(), request.getArtifact(), request.getRemoteRepositories());
        }
    }

    private static <T> List<T> toList(Collection<T> items) {
        return items != null ? new ArrayList<T>(items) : null;
    }
}

