/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.model.Exclusion;
import java.util.List;

public class ExclusionArtifactFilter
implements ArtifactFilter {
    private static final String WILDCARD = "io.quarkus.launcher.shaded.*";
    private final List<Exclusion> exclusions;

    public ExclusionArtifactFilter(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public boolean include(Artifact artifact) {
        for (Exclusion exclusion : this.exclusions) {
            if (WILDCARD.equals(exclusion.getGroupId()) && WILDCARD.equals(exclusion.getArtifactId())) {
                return false;
            }
            if (WILDCARD.equals(exclusion.getGroupId()) && exclusion.getArtifactId().equals(artifact.getArtifactId())) {
                return false;
            }
            if (WILDCARD.equals(exclusion.getArtifactId()) && exclusion.getGroupId().equals(artifact.getGroupId())) {
                return false;
            }
            if (!exclusion.getGroupId().equals(artifact.getGroupId()) || !exclusion.getArtifactId().equals(artifact.getArtifactId())) continue;
            return false;
        }
        return true;
    }
}

