/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExclusionSetFilter
implements ArtifactFilter {
    private Set<String> excludes;

    public ExclusionSetFilter(String[] excludes) {
        this.excludes = new LinkedHashSet<String>(Arrays.asList(excludes));
    }

    public ExclusionSetFilter(Set<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    public boolean include(Artifact artifact) {
        String id = artifact.getArtifactId();
        if (this.excludes.contains(id)) {
            return false;
        }
        id = artifact.getGroupId() + ':' + id;
        return !this.excludes.contains(id);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.excludes.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExclusionSetFilter)) {
            return false;
        }
        ExclusionSetFilter other = (ExclusionSetFilter)obj;
        return this.excludes.equals(other.excludes);
    }
}

