/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.bridge;

import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.InvalidRepositoryException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.ArtifactHandler;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.MavenArtifactRepository;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout2;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.resolver.filter.ExclusionArtifactFilter;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.versioning.VersionRange;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.repository.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.settings.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Authentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.AuthenticationContext;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.AuthenticationSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.MirrorSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ProxySelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component(role=MavenRepositorySystem.class, hint="io.quarkus.launcher.shaded.default")
public class MavenRepositorySystem {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> layouts;
    private static final String WILDCARD = "io.quarkus.launcher.shaded.*";
    private static final String EXTERNAL_WILDCARD = "io.quarkus.launcher.shaded.external:*";

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.createArtifactX(groupId, artifactId, version, scope, type);
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String metaVersionId) {
        return this.createProjectArtifactX(groupId, artifactId, metaVersionId);
    }

    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        if (d.getVersion() == null) {
            return null;
        }
        try {
            versionRange = VersionRange.createFromVersionSpec(d.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        Artifact artifact = this.createDependencyArtifactX(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
        if ("io.quarkus.launcher.shaded.system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            artifact.setDependencyFilter(new ExclusionArtifactFilter(d.getExclusions()));
        }
        return artifact;
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, String version) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec(version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.createExtensionArtifactX(groupId, artifactId, versionRange);
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.createParentArtifactX(groupId, artifactId, version);
    }

    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        try {
            String version = plugin.getVersion();
            if (StringUtils.isEmpty(version)) {
                version = "io.quarkus.launcher.shaded.RELEASE";
            }
            versionRange = VersionRange.createFromVersionSpec(version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.createPluginArtifactX(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
    }

    public void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = MavenRepositorySystem.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private Mirror getMirror(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        MirrorSelector selector;
        if (session != null && (selector = session.getMirrorSelector()) != null && (repo = selector.getMirror(RepositoryUtils.toRepo(repository))) != null) {
            Mirror mirror = new Mirror();
            mirror.setId(repo.getId());
            mirror.setUrl(repo.getUrl());
            mirror.setLayout(repo.getContentType());
            return mirror;
        }
        return null;
    }

    public void injectMirror(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(session, repository);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = MavenRepositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (StringUtils.isNotEmpty(mirror.getLayout())) {
                repository.setLayout(this.getLayout(mirror.getLayout()));
            }
        }
    }

    private io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.Authentication getAuthentication(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        Authentication auth;
        AuthenticationSelector selector;
        if (session != null && (selector = session.getAuthenticationSelector()) != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo(repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository(session, repo);
            io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.Authentication result = new io.quarkus.launcher.shaded.org.apache.maven.artifact.repository.Authentication(authCtx.get("io.quarkus.launcher.shaded.username"), authCtx.get("io.quarkus.launcher.shaded.password"));
            result.setPrivateKey(authCtx.get("io.quarkus.launcher.shaded.privateKey.path"));
            result.setPassphrase(authCtx.get("io.quarkus.launcher.shaded.privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }

    public void injectAuthentication(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(session, repository));
            }
        }
    }

    private Proxy getProxy(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy proxy;
        ProxySelector selector;
        if (session != null && (selector = session.getProxySelector()) != null && (proxy = selector.getProxy(repo = RepositoryUtils.toRepo(repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy.getHost());
            p.setProtocol(proxy.getType());
            p.setPort(proxy.getPort());
            if (proxy.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy(session, repo);
                p.setUserName(authCtx.get("io.quarkus.launcher.shaded.username"));
                p.setPassword(authCtx.get("io.quarkus.launcher.shaded.password"));
                p.setNtlmDomain(authCtx.get("io.quarkus.launcher.shaded.ntlm.domain"));
                p.setNtlmHost(authCtx.get("io.quarkus.launcher.shaded.ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    public void injectProxy(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(session, repository));
            }
        }
    }

    private ArtifactRepositoryLayout getLayout(String id) {
        ArtifactRepositoryLayout layout = this.layouts.get(id);
        return layout;
    }

    public static io.quarkus.launcher.shaded.org.apache.maven.model.Repository fromSettingsRepository(Repository settingsRepository) {
        io.quarkus.launcher.shaded.org.apache.maven.model.Repository modelRepository = new io.quarkus.launcher.shaded.org.apache.maven.model.Repository();
        modelRepository.setId(settingsRepository.getId());
        modelRepository.setLayout(settingsRepository.getLayout());
        modelRepository.setName(settingsRepository.getName());
        modelRepository.setUrl(settingsRepository.getUrl());
        modelRepository.setReleases(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getReleases()));
        modelRepository.setSnapshots(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getSnapshots()));
        return modelRepository;
    }

    public static io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy fromSettingsRepositoryPolicy(RepositoryPolicy settingsRepositoryPolicy) {
        io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy modelRepositoryPolicy = new io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy();
        if (settingsRepositoryPolicy != null) {
            modelRepositoryPolicy.setEnabled(settingsRepositoryPolicy.isEnabled());
            modelRepositoryPolicy.setUpdatePolicy(settingsRepositoryPolicy.getUpdatePolicy());
            modelRepositoryPolicy.setChecksumPolicy(settingsRepositoryPolicy.getChecksumPolicy());
        }
        return modelRepositoryPolicy;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        return MavenRepositorySystem.buildArtifactRepository(MavenRepositorySystem.fromSettingsRepository(repo));
    }

    public static ArtifactRepository buildArtifactRepository(io.quarkus.launcher.shaded.org.apache.maven.model.Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            if (StringUtils.isEmpty(id)) {
                throw new InvalidRepositoryException("io.quarkus.launcher.shaded.Repository identifier missing", "io.quarkus.launcher.shaded.");
            }
            String url = repo.getUrl();
            if (StringUtils.isEmpty(url)) {
                throw new InvalidRepositoryException("io.quarkus.launcher.shaded.URL missing for repository " + id, id);
            }
            ArtifactRepositoryPolicy snapshots = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getReleases());
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
        }
        return null;
    }

    public static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws Exception {
        ArtifactRepositoryLayout layout = this.layouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
    }

    private void checkLayout(String repositoryId, String layoutId, ArtifactRepositoryLayout layout) throws Exception {
        if (layout == null) {
            throw new Exception(String.format("io.quarkus.launcher.shaded.Cannot find ArtifactRepositoryLayout instance for: %s %s", layoutId, repositoryId));
        }
    }

    public static ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        ArtifactRepository repository = repositoryLayout instanceof ArtifactRepositoryLayout2 ? ((ArtifactRepositoryLayout2)repositoryLayout).newMavenArtifactRepository(id, url, snapshots, releases) : new MavenArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        return repository;
    }

    private Artifact createArtifactX(String groupId, String artifactId, String version, String scope, String type) {
        return this.createArtifactX(groupId, artifactId, version, scope, type, null, null);
    }

    private Artifact createDependencyArtifactX(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.createArtifactX(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
    }

    private Artifact createProjectArtifactX(String groupId, String artifactId, String version) {
        return this.createProjectArtifactX(groupId, artifactId, version, null);
    }

    private Artifact createParentArtifactX(String groupId, String artifactId, String version) {
        return this.createProjectArtifactX(groupId, artifactId, version);
    }

    private Artifact createPluginArtifactX(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifactX(groupId, artifactId, versionRange, "io.quarkus.launcher.shaded.maven-plugin", null, "io.quarkus.launcher.shaded.runtime", null);
    }

    private Artifact createProjectArtifactX(String groupId, String artifactId, String version, String scope) {
        return this.createArtifactX(groupId, artifactId, version, scope, "io.quarkus.launcher.shaded.pom");
    }

    private Artifact createExtensionArtifactX(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifactX(groupId, artifactId, versionRange, "io.quarkus.launcher.shaded.jar", null, "io.quarkus.launcher.shaded.runtime", null);
    }

    private Artifact createArtifactX(String groupId, String artifactId, String version, String scope, String type, String classifier, String inheritedScope) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion(version);
        }
        return this.createArtifactX(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    private Artifact createArtifactX(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.createArtifactX(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, false);
    }

    private Artifact createArtifactX(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "io.quarkus.launcher.shaded.runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("io.quarkus.launcher.shaded.test".equals(scope) || "io.quarkus.launcher.shaded.provided".equals(scope)) {
                return null;
            }
            if ("io.quarkus.launcher.shaded.compile".equals(scope) && "io.quarkus.launcher.shaded.compile".equals(inheritedScope)) {
                desiredScope = "io.quarkus.launcher.shaded.compile";
            }
        }
        if ("io.quarkus.launcher.shaded.test".equals(inheritedScope)) {
            desiredScope = "io.quarkus.launcher.shaded.test";
        }
        if ("io.quarkus.launcher.shaded.provided".equals(inheritedScope)) {
            desiredScope = "io.quarkus.launcher.shaded.provided";
        }
        if ("io.quarkus.launcher.shaded.system".equals(scope)) {
            desiredScope = "io.quarkus.launcher.shaded.system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type, classifier, handler, optional);
    }

    public ArtifactRepository createDefaultRemoteRepository(MavenExecutionRequest request) throws Exception {
        return this.createRepository("io/quarkus/launcher/shaded/https://repo.maven.apache.org/maven2", "io.quarkus.launcher.shaded.central", true, "io.quarkus.launcher.shaded.daily", false, "io.quarkus.launcher.shaded.daily", "io.quarkus.launcher.shaded.warn");
    }

    public ArtifactRepository createRepository(String url, String repositoryId, boolean releases, String releaseUpdates, boolean snapshots, String snapshotUpdates, String checksumPolicy) throws Exception {
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(snapshots, snapshotUpdates, checksumPolicy);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(releases, releaseUpdates, checksumPolicy);
        return this.createArtifactRepository(repositoryId, url, "io.quarkus.launcher.shaded.default", snapshotsPolicy, releasesPolicy);
    }

    public Set<String> getRepoIds(List<ArtifactRepository> repositories) {
        HashSet<String> repoIds = new HashSet<String>();
        if (repositories != null) {
            for (ArtifactRepository repository : repositories) {
                repoIds.add(repository.getId());
            }
        }
        return repoIds;
    }

    public List<ArtifactRepository> getEffectiveRepositories(List<ArtifactRepository> repositories) {
        if (repositories == null) {
            return null;
        }
        LinkedHashMap<String, ArrayList<ArtifactRepository>> reposByKey = new LinkedHashMap<String, ArrayList<ArtifactRepository>>();
        for (ArtifactRepository repository : repositories) {
            String key = repository.getId();
            ArrayList<ArtifactRepository> aliasedRepos = (ArrayList<ArtifactRepository>)reposByKey.get(key);
            if (aliasedRepos == null) {
                aliasedRepos = new ArrayList<ArtifactRepository>();
                reposByKey.put(key, aliasedRepos);
            }
            aliasedRepos.add(repository);
        }
        ArrayList<ArtifactRepository> effectiveRepositories = new ArrayList<ArtifactRepository>();
        for (List aliasedRepos : reposByKey.values()) {
            ArtifactRepository aliasedRepo3;
            ArrayList<ArtifactRepository> mirroredRepos = new ArrayList<ArtifactRepository>();
            ArrayList<ArtifactRepositoryPolicy> releasePolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo2 : aliasedRepos) {
                releasePolicies.add(aliasedRepo2.getReleases());
                mirroredRepos.addAll(aliasedRepo2.getMirroredRepositories());
            }
            ArtifactRepositoryPolicy releasePolicy = this.getEffectivePolicy(releasePolicies);
            ArrayList<ArtifactRepositoryPolicy> snapshotPolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo3 : aliasedRepos) {
                snapshotPolicies.add(aliasedRepo3.getSnapshots());
            }
            ArtifactRepositoryPolicy snapshotPolicy = this.getEffectivePolicy(snapshotPolicies);
            aliasedRepo3 = (ArtifactRepository)aliasedRepos.get(0);
            ArtifactRepository effectiveRepository = MavenRepositorySystem.createArtifactRepository(aliasedRepo3.getId(), aliasedRepo3.getUrl(), aliasedRepo3.getLayout(), snapshotPolicy, releasePolicy);
            effectiveRepository.setAuthentication(aliasedRepo3.getAuthentication());
            effectiveRepository.setProxy(aliasedRepo3.getProxy());
            effectiveRepository.setMirroredRepositories(mirroredRepos);
            effectiveRepositories.add(effectiveRepository);
        }
        return effectiveRepositories;
    }

    private ArtifactRepositoryPolicy getEffectivePolicy(Collection<ArtifactRepositoryPolicy> policies) {
        ArtifactRepositoryPolicy effectivePolicy = null;
        for (ArtifactRepositoryPolicy policy : policies) {
            if (effectivePolicy == null) {
                effectivePolicy = new ArtifactRepositoryPolicy(policy);
                continue;
            }
            effectivePolicy.merge(policy);
        }
        return effectivePolicy;
    }

    public ArtifactRepository createLocalRepository(MavenExecutionRequest request, File localRepository) throws Exception {
        return this.createRepository("io/quarkus/launcher/shaded/file://" + localRepository.toURI().getRawPath(), "io.quarkus.launcher.shaded.local", true, "io.quarkus.launcher.shaded.always", true, "io.quarkus.launcher.shaded.always", "io.quarkus.launcher.shaded.ignore");
    }

    public static Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        String repoId = repository.getId();
        if (repoId != null && mirrors != null) {
            for (Mirror mirror : mirrors) {
                if (!repoId.equals(mirror.getMirrorOf()) || !MavenRepositorySystem.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
            for (Mirror mirror : mirrors) {
                if (!MavenRepositorySystem.matchPattern(repository, mirror.getMirrorOf()) || !MavenRepositorySystem.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(ArtifactRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split("io.quarkus.launcher.shaded.,")) {
                if (repo.length() > 1 && repo.startsWith("io.quarkus.launcher.shaded.!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && MavenRepositorySystem.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !url.getHost().equals("io.quarkus.launcher.shaded.localhost") && !url.getHost().equals("io.quarkus.launcher.shaded.127.0.0.1") && !url.getProtocol().equals("io.quarkus.launcher.shaded.file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    static boolean matchesLayout(ArtifactRepository repository, Mirror mirror) {
        return MavenRepositorySystem.matchesLayout(RepositoryUtils.getLayout(repository), mirror.getMirrorOfLayouts());
    }

    static boolean matchesLayout(String repoLayout, String mirrorLayout) {
        boolean result = false;
        if (StringUtils.isEmpty(mirrorLayout) || WILDCARD.equals(mirrorLayout)) {
            result = true;
        } else if (mirrorLayout.equals(repoLayout)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorLayout.split("io.quarkus.launcher.shaded.,")) {
                if (layout.length() > 1 && layout.startsWith("io.quarkus.launcher.shaded.!")) {
                    if (!layout.substring(1).equals(repoLayout)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoLayout)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }
}

