/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.classrealm;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.ArtifactUtils;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ArtifactClassRealmConstituent;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ClassRealmConstituent;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ClassRealmManager;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ClassRealmManagerDelegate;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.ClassRealmRequest;
import io.quarkus.launcher.shaded.org.apache.maven.classrealm.DefaultClassRealmRequest;
import io.quarkus.launcher.shaded.org.apache.maven.extension.internal.CoreExportsProvider;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.codehaus.plexus.MutablePlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.ClassWorld;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

@Named
@Singleton
public class DefaultClassRealmManager
implements ClassRealmManager {
    public static final String API_REALMID = "io.quarkus.launcher.shaded.maven.api";
    private static final ClassLoader PARENT_CLASSLOADER = ClassWorld.class.getClassLoader();
    private final Logger logger;
    private final ClassWorld world;
    private final ClassRealm containerRealm;
    private final List<ClassRealmManagerDelegate> delegates;
    private final ClassRealm mavenApiRealm;
    private final Set<String> providedArtifacts;

    @Inject
    public DefaultClassRealmManager(Logger logger, PlexusContainer container, List<ClassRealmManagerDelegate> delegates, CoreExportsProvider exports) {
        this.logger = logger;
        this.world = ((MutablePlexusContainer)container).getClassWorld();
        this.containerRealm = container.getContainerRealm();
        this.delegates = delegates;
        Map<String, ClassLoader> foreignImports = exports.get().getExportedPackages();
        this.mavenApiRealm = this.createRealm(API_REALMID, ClassRealmRequest.RealmType.Core, null, null, foreignImports, null);
        this.providedArtifacts = exports.get().getExportedArtifacts();
    }

    private ClassRealm newRealm(String id) {
        ClassWorld classWorld = this.world;
        synchronized (classWorld) {
            String realmId = id;
            Random random = new Random();
            while (true) {
                try {
                    ClassRealm classRealm = this.world.newRealm(realmId, null);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("io.quarkus.launcher.shaded.Created new class realm " + realmId);
                    }
                    return classRealm;
                }
                catch (DuplicateRealmException e) {
                    realmId = id + '-' + random.nextInt();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public ClassRealm getMavenApiRealm() {
        return this.mavenApiRealm;
    }

    private ClassRealm createRealm(String baseRealmId, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (this.isProvidedArtifact(artifact)) continue;
                artifactIds.add(DefaultClassRealmManager.getId(artifact));
                if (artifact.getFile() == null) continue;
                constituents.add(new ArtifactClassRealmConstituent(artifact));
            }
        }
        parentImports = parentImports != null ? new ArrayList<String>(parentImports) : new ArrayList<String>();
        foreignImports = foreignImports != null ? new TreeMap<String, ClassLoader>(foreignImports) : new TreeMap<String, ClassLoader>();
        ClassRealm classRealm = this.newRealm(baseRealmId);
        if (parent != null) {
            classRealm.setParentClassLoader(parent);
        }
        this.callDelegates(classRealm, type, parent, parentImports, foreignImports, constituents);
        this.wireRealm(classRealm, parentImports, foreignImports);
        Set<String> includedIds = this.populateRealm(classRealm, constituents);
        if (this.logger.isDebugEnabled()) {
            artifactIds.removeAll(includedIds);
            for (String id : artifactIds) {
                this.logger.debug("io.quarkus.launcher.shaded.  Excluded: " + id);
            }
        }
        return classRealm;
    }

    @Override
    public ClassRealm getCoreRealm() {
        return this.containerRealm;
    }

    @Override
    public ClassRealm createProjectRealm(Model model, List<Artifact> artifacts) {
        Objects.requireNonNull(model, "io.quarkus.launcher.shaded.model cannot be null");
        ClassRealm parent = this.getMavenApiRealm();
        return this.createRealm(DefaultClassRealmManager.getKey(model), ClassRealmRequest.RealmType.Project, parent, null, null, artifacts);
    }

    private static String getKey(Model model) {
        return "io.quarkus.launcher.shaded.project>" + model.getGroupId() + "io.quarkus.launcher.shaded.:" + model.getArtifactId() + "io.quarkus.launcher.shaded.:" + model.getVersion();
    }

    @Override
    public ClassRealm createExtensionRealm(Plugin plugin, List<Artifact> artifacts) {
        Objects.requireNonNull(plugin, "io.quarkus.launcher.shaded.plugin cannot be null");
        ClassLoader parent = PARENT_CLASSLOADER;
        Map<String, ClassLoader> foreignImports = Collections.singletonMap("io.quarkus.launcher.shaded.", this.getMavenApiRealm());
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, true), ClassRealmRequest.RealmType.Extension, parent, null, foreignImports, artifacts);
    }

    private boolean isProvidedArtifact(Artifact artifact) {
        return this.providedArtifacts.contains(artifact.getGroupId() + "io.quarkus.launcher.shaded.:" + artifact.getArtifactId());
    }

    @Override
    public ClassRealm createPluginRealm(Plugin plugin, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        Objects.requireNonNull(plugin, "io.quarkus.launcher.shaded.plugin cannot be null");
        if (parent == null) {
            parent = PARENT_CLASSLOADER;
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, false), ClassRealmRequest.RealmType.Plugin, parent, parentImports, foreignImports, artifacts);
    }

    private static String getKey(Plugin plugin, boolean extension) {
        String version = ArtifactUtils.toSnapshotVersion(plugin.getVersion());
        return (extension ? "io.quarkus.launcher.shaded.extension>" : "io.quarkus.launcher.shaded.plugin>") + plugin.getGroupId() + "io.quarkus.launcher.shaded.:" + plugin.getArtifactId() + "io.quarkus.launcher.shaded.:" + version;
    }

    private static String getId(Artifact artifact) {
        return DefaultClassRealmManager.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
    }

    private static String getId(ClassRealmConstituent constituent) {
        return DefaultClassRealmManager.getId(constituent.getGroupId(), constituent.getArtifactId(), constituent.getType(), constituent.getClassifier(), constituent.getVersion());
    }

    private static String getId(String gid, String aid, String type, String cls, String ver) {
        return gid + ':' + aid + ':' + type + (StringUtils.isNotEmpty(cls) ? ':' + cls : "io.quarkus.launcher.shaded.") + ':' + ver;
    }

    private void callDelegates(ClassRealm classRealm, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<ClassRealmConstituent> constituents) {
        ArrayList<ClassRealmManagerDelegate> delegates = new ArrayList<ClassRealmManagerDelegate>(this.delegates);
        if (!delegates.isEmpty()) {
            DefaultClassRealmRequest request = new DefaultClassRealmRequest(type, parent, parentImports, foreignImports, constituents);
            for (ClassRealmManagerDelegate delegate : delegates) {
                try {
                    delegate.setupRealm(classRealm, request);
                }
                catch (Exception e) {
                    this.logger.error(delegate.getClass().getName() + "io.quarkus.launcher.shaded. failed to setup class realm " + classRealm + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
                }
            }
        }
    }

    private Set<String> populateRealm(ClassRealm classRealm, List<ClassRealmConstituent> constituents) {
        LinkedHashSet<String> includedIds = new LinkedHashSet<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("io.quarkus.launcher.shaded.Populating class realm " + classRealm.getId());
        }
        for (ClassRealmConstituent constituent : constituents) {
            File file = constituent.getFile();
            String id = DefaultClassRealmManager.getId(constituent);
            includedIds.add(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("io.quarkus.launcher.shaded.  Included: " + id);
            }
            try {
                classRealm.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return includedIds;
    }

    private void wireRealm(ClassRealm classRealm, List<String> parentImports, Map<String, ClassLoader> foreignImports) {
        if (foreignImports != null && !foreignImports.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("io.quarkus.launcher.shaded.Importing foreign packages into class realm " + classRealm.getId());
            }
            for (Map.Entry entry : foreignImports.entrySet()) {
                ClassLoader importedRealm = (ClassLoader)entry.getValue();
                String imp = (String)entry.getKey();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("io.quarkus.launcher.shaded.  Imported: " + imp + "io.quarkus.launcher.shaded. < " + this.getId(importedRealm));
                }
                classRealm.importFrom(importedRealm, imp);
            }
        }
        if (parentImports != null && !parentImports.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("io.quarkus.launcher.shaded.Importing parent packages into class realm " + classRealm.getId());
            }
            for (String string : parentImports) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("io.quarkus.launcher.shaded.  Imported: " + string + "io.quarkus.launcher.shaded. < " + this.getId(classRealm.getParentClassLoader()));
                }
                classRealm.importFromParent(string);
            }
        }
    }

    private String getId(ClassLoader classLoader) {
        if (classLoader instanceof ClassRealm) {
            return ((ClassRealm)classLoader).getId();
        }
        return String.valueOf(classLoader);
    }
}

