/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli;

import io.quarkus.launcher.shaded.org.apache.commons.cli.CommandLine;
import io.quarkus.launcher.shaded.org.apache.commons.cli.GnuParser;
import io.quarkus.launcher.shaded.org.apache.commons.cli.HelpFormatter;
import io.quarkus.launcher.shaded.org.apache.commons.cli.Option;
import io.quarkus.launcher.shaded.org.apache.commons.cli.Options;
import io.quarkus.launcher.shaded.org.apache.commons.cli.ParseException;
import io.quarkus.launcher.shaded.org.apache.maven.cli.CleanArgument;
import java.io.PrintStream;
import java.io.PrintWriter;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SHOW_VERSION = 'V';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String SUPRESS_SNAPSHOT_UPDATES = "io.quarkus.launcher.shaded.nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String ALTERNATE_GLOBAL_SETTINGS = "io.quarkus.launcher.shaded.gs";
    public static final char ALTERNATE_USER_TOOLCHAINS = 't';
    public static final String ALTERNATE_GLOBAL_TOOLCHAINS = "io.quarkus.launcher.shaded.gt";
    public static final String FAIL_FAST = "io.quarkus.launcher.shaded.ff";
    public static final String FAIL_AT_END = "io.quarkus.launcher.shaded.fae";
    public static final String FAIL_NEVER = "io.quarkus.launcher.shaded.fn";
    public static final String RESUME_FROM = "io.quarkus.launcher.shaded.rf";
    public static final String PROJECT_LIST = "io.quarkus.launcher.shaded.pl";
    public static final String ALSO_MAKE = "io.quarkus.launcher.shaded.am";
    public static final String ALSO_MAKE_DEPENDENTS = "io.quarkus.launcher.shaded.amd";
    public static final String LOG_FILE = "io.quarkus.launcher.shaded.l";
    public static final String ENCRYPT_MASTER_PASSWORD = "io.quarkus.launcher.shaded.emp";
    public static final String ENCRYPT_PASSWORD = "io.quarkus.launcher.shaded.ep";
    public static final String THREADS = "io.quarkus.launcher.shaded.T";
    public static final String LEGACY_LOCAL_REPOSITORY = "io.quarkus.launcher.shaded.llr";
    public static final String BUILDER = "io.quarkus.launcher.shaded.b";
    public static final String NO_TRANSFER_PROGRESS = "io.quarkus.launcher.shaded.ntp";
    protected Options options = new Options();

    public CLIManager() {
        this.options.addOption(Option.builder(Character.toString('h')).longOpt("io.quarkus.launcher.shaded.help").desc("io.quarkus.launcher.shaded.Display help information").build());
        this.options.addOption(Option.builder(Character.toString('f')).longOpt("io.quarkus.launcher.shaded.file").hasArg().desc("io.quarkus.launcher.shaded.Force the use of an alternate POM file (or directory with pom.xml)").build());
        this.options.addOption(Option.builder(Character.toString('D')).longOpt("io.quarkus.launcher.shaded.define").hasArg().desc("io.quarkus.launcher.shaded.Define a system property").build());
        this.options.addOption(Option.builder(Character.toString('o')).longOpt("io.quarkus.launcher.shaded.offline").desc("io.quarkus.launcher.shaded.Work offline").build());
        this.options.addOption(Option.builder(Character.toString('v')).longOpt("io.quarkus.launcher.shaded.version").desc("io.quarkus.launcher.shaded.Display version information").build());
        this.options.addOption(Option.builder(Character.toString('q')).longOpt("io.quarkus.launcher.shaded.quiet").desc("io.quarkus.launcher.shaded.Quiet output - only show errors").build());
        this.options.addOption(Option.builder(Character.toString('X')).longOpt("io.quarkus.launcher.shaded.debug").desc("io.quarkus.launcher.shaded.Produce execution debug output").build());
        this.options.addOption(Option.builder(Character.toString('e')).longOpt("io.quarkus.launcher.shaded.errors").desc("io.quarkus.launcher.shaded.Produce execution error messages").build());
        this.options.addOption(Option.builder(Character.toString('N')).longOpt("io.quarkus.launcher.shaded.non-recursive").desc("io.quarkus.launcher.shaded.Do not recurse into sub-projects").build());
        this.options.addOption(Option.builder(Character.toString('U')).longOpt("io.quarkus.launcher.shaded.update-snapshots").desc("io.quarkus.launcher.shaded.Forces a check for missing releases and updated snapshots on remote repositories").build());
        this.options.addOption(Option.builder(Character.toString('P')).longOpt("io.quarkus.launcher.shaded.activate-profiles").desc("io.quarkus.launcher.shaded.Comma-delimited list of profiles to activate").hasArg().build());
        this.options.addOption(Option.builder(Character.toString('B')).longOpt("io.quarkus.launcher.shaded.batch-mode").desc("io.quarkus.launcher.shaded.Run in non-interactive (batch) mode (disables output color)").build());
        this.options.addOption(Option.builder(SUPRESS_SNAPSHOT_UPDATES).longOpt("io.quarkus.launcher.shaded.no-snapshot-updates").desc("io.quarkus.launcher.shaded.Suppress SNAPSHOT updates").build());
        this.options.addOption(Option.builder(Character.toString('C')).longOpt("io.quarkus.launcher.shaded.strict-checksums").desc("io.quarkus.launcher.shaded.Fail the build if checksums don't match").build());
        this.options.addOption(Option.builder(Character.toString('c')).longOpt("io.quarkus.launcher.shaded.lax-checksums").desc("io.quarkus.launcher.shaded.Warn if checksums don't match").build());
        this.options.addOption(Option.builder(Character.toString('s')).longOpt("io.quarkus.launcher.shaded.settings").desc("io.quarkus.launcher.shaded.Alternate path for the user settings file").hasArg().build());
        this.options.addOption(Option.builder(ALTERNATE_GLOBAL_SETTINGS).longOpt("io.quarkus.launcher.shaded.global-settings").desc("io.quarkus.launcher.shaded.Alternate path for the global settings file").hasArg().build());
        this.options.addOption(Option.builder(Character.toString('t')).longOpt("io.quarkus.launcher.shaded.toolchains").desc("io.quarkus.launcher.shaded.Alternate path for the user toolchains file").hasArg().build());
        this.options.addOption(Option.builder(ALTERNATE_GLOBAL_TOOLCHAINS).longOpt("io.quarkus.launcher.shaded.global-toolchains").desc("io.quarkus.launcher.shaded.Alternate path for the global toolchains file").hasArg().build());
        this.options.addOption(Option.builder(FAIL_FAST).longOpt("io.quarkus.launcher.shaded.fail-fast").desc("io.quarkus.launcher.shaded.Stop at first failure in reactorized builds").build());
        this.options.addOption(Option.builder(FAIL_AT_END).longOpt("io.quarkus.launcher.shaded.fail-at-end").desc("io.quarkus.launcher.shaded.Only fail the build afterwards; allow all non-impacted builds to continue").build());
        this.options.addOption(Option.builder(FAIL_NEVER).longOpt("io.quarkus.launcher.shaded.fail-never").desc("io.quarkus.launcher.shaded.NEVER fail the build, regardless of project result").build());
        this.options.addOption(Option.builder(RESUME_FROM).longOpt("io.quarkus.launcher.shaded.resume-from").hasArg().desc("io.quarkus.launcher.shaded.Resume reactor from specified project").build());
        this.options.addOption(Option.builder(PROJECT_LIST).longOpt("io.quarkus.launcher.shaded.projects").desc("io.quarkus.launcher.shaded.Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path").hasArg().build());
        this.options.addOption(Option.builder(ALSO_MAKE).longOpt("io.quarkus.launcher.shaded.also-make").desc("io.quarkus.launcher.shaded.If project list is specified, also build projects required by the list").build());
        this.options.addOption(Option.builder(ALSO_MAKE_DEPENDENTS).longOpt("io.quarkus.launcher.shaded.also-make-dependents").desc("io.quarkus.launcher.shaded.If project list is specified, also build projects that depend on projects on the list").build());
        this.options.addOption(Option.builder(LOG_FILE).longOpt("io.quarkus.launcher.shaded.log-file").hasArg().desc("io.quarkus.launcher.shaded.Log file where all build output will go (disables output color)").build());
        this.options.addOption(Option.builder(Character.toString('V')).longOpt("io.quarkus.launcher.shaded.show-version").desc("io.quarkus.launcher.shaded.Display version information WITHOUT stopping build").build());
        this.options.addOption(Option.builder(ENCRYPT_MASTER_PASSWORD).longOpt("io.quarkus.launcher.shaded.encrypt-master-password").hasArg().optionalArg(true).desc("io.quarkus.launcher.shaded.Encrypt master security password").build());
        this.options.addOption(Option.builder(ENCRYPT_PASSWORD).longOpt("io.quarkus.launcher.shaded.encrypt-password").hasArg().optionalArg(true).desc("io.quarkus.launcher.shaded.Encrypt server password").build());
        this.options.addOption(Option.builder(THREADS).longOpt("io.quarkus.launcher.shaded.threads").hasArg().desc("io.quarkus.launcher.shaded.Thread count, for instance 2.0C where C is core multiplied").build());
        this.options.addOption(Option.builder(LEGACY_LOCAL_REPOSITORY).longOpt("io.quarkus.launcher.shaded.legacy-local-repository").desc("io.quarkus.launcher.shaded.Use Maven 2 Legacy Local Repository behaviour, ie no use of _remote.repositories. Can also be activated by using -Dmaven.legacyLocalRepo=true").build());
        this.options.addOption(Option.builder(BUILDER).longOpt("io.quarkus.launcher.shaded.builder").hasArg().desc("io.quarkus.launcher.shaded.The id of the build strategy to use").build());
        this.options.addOption(Option.builder(NO_TRANSFER_PROGRESS).longOpt("io.quarkus.launcher.shaded.no-transfer-progress").desc("io.quarkus.launcher.shaded.Do not display transfer progress when downloading or uploading").build());
        this.options.addOption(Option.builder("io.quarkus.launcher.shaded.npr").longOpt("io.quarkus.launcher.shaded.no-plugin-registry").desc("io.quarkus.launcher.shaded.Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder("io.quarkus.launcher.shaded.cpu").longOpt("io.quarkus.launcher.shaded.check-plugin-updates").desc("io.quarkus.launcher.shaded.Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder("io.quarkus.launcher.shaded.up").longOpt("io.quarkus.launcher.shaded.update-plugins").desc("io.quarkus.launcher.shaded.Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder("io.quarkus.launcher.shaded.npu").longOpt("io.quarkus.launcher.shaded.no-plugin-updates").desc("io.quarkus.launcher.shaded.Ineffective, only kept for backward compatibility").build());
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = CleanArgument.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    public void displayHelp(PrintStream stdout) {
        stdout.println();
        PrintWriter pw = new PrintWriter(stdout);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 74, "io.quarkus.launcher.shaded.mvn [options] [<goal(s)>] [<phase(s)>]", "io.quarkus.launcher.shaded.\nOptions:", this.options, 1, 3, "io.quarkus.launcher.shaded.\n", false);
        pw.flush();
    }
}

