/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.StringUtils;
import io.quarkus.launcher.shaded.org.apache.maven.cli.MavenCli;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.logging.MessageUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.Os;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public final class CLIReportingUtils {
    public static final long MB = 0x100000L;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    public static final String BUILD_VERSION_PROPERTY = "io.quarkus.launcher.shaded.version";

    public static String showVersion() {
        String ls = System.getProperty("io.quarkus.launcher.shaded.line.separator");
        Properties properties = CLIReportingUtils.getBuildProperties();
        StringBuilder version = new StringBuilder(256);
        version.append(MessageUtils.buffer().strong(CLIReportingUtils.createMavenVersionString(properties))).append(ls);
        version.append(CLIReportingUtils.reduce(properties.getProperty("io.quarkus.launcher.shaded.distributionShortName") + "io.quarkus.launcher.shaded. home: " + System.getProperty("io.quarkus.launcher.shaded.maven.home", "io.quarkus.launcher.shaded.<unknown Maven home>"))).append(ls);
        version.append("io.quarkus.launcher.shaded.Java version: ").append(System.getProperty("io/quarkus/launcher/shaded/java.version", "io.quarkus.launcher.shaded.<unknown Java version>")).append("io.quarkus.launcher.shaded., vendor: ").append(System.getProperty("io/quarkus/launcher/shaded/java.vendor", "io.quarkus.launcher.shaded.<unknown vendor>")).append("io.quarkus.launcher.shaded., runtime: ").append(System.getProperty("io/quarkus/launcher/shaded/java.home", "io.quarkus.launcher.shaded.<unknown runtime>")).append(ls);
        version.append("io.quarkus.launcher.shaded.Default locale: ").append(Locale.getDefault()).append("io.quarkus.launcher.shaded., platform encoding: ").append(System.getProperty("io.quarkus.launcher.shaded.file.encoding", "io.quarkus.launcher.shaded.<unknown encoding>")).append(ls);
        version.append("io.quarkus.launcher.shaded.OS name: \"").append(Os.OS_NAME).append("io.quarkus.launcher.shaded.\", version: \"").append(Os.OS_VERSION).append("io.quarkus.launcher.shaded.\", arch: \"").append(Os.OS_ARCH).append("io.quarkus.launcher.shaded.\", family: \"").append(Os.OS_FAMILY).append('\"');
        return version.toString();
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = CLIReportingUtils.reduce(buildProperties.getProperty("io.quarkus.launcher.shaded.timestamp"));
        String version = CLIReportingUtils.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = CLIReportingUtils.reduce(buildProperties.getProperty("io.quarkus.launcher.shaded.buildNumber"));
        String distributionName = CLIReportingUtils.reduce(buildProperties.getProperty("io.quarkus.launcher.shaded.distributionName"));
        String msg = distributionName + "io.quarkus.launcher.shaded. ";
        msg = msg + (version != null ? version : "io.quarkus.launcher.shaded.<version unknown>");
        if (rev != null || timestamp != null) {
            msg = msg + "io.quarkus.launcher.shaded. (";
            msg = msg + (rev != null ? rev : "io.quarkus.launcher.shaded.");
            if (StringUtils.isNotBlank(timestamp)) {
                String ts = CLIReportingUtils.formatTimestamp(Long.valueOf(timestamp));
                msg = msg + (rev != null ? "io.quarkus.launcher.shaded.; " : "io.quarkus.launcher.shaded.") + ts;
            }
            msg = msg + "io.quarkus.launcher.shaded.)";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("io.quarkus.launcher.shaded.${") && s.endsWith("io.quarkus.launcher.shaded.}") ? null : s) : null;
    }

    static Properties getBuildProperties() {
        Properties properties = new Properties();
        try (InputStream resourceAsStream = MavenCli.class.getResourceAsStream("io/quarkus/launcher/shaded//org/apache/maven/messages/build.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("io.quarkus.launcher.shaded.Unable determine version from JAR file: " + e.getMessage());
        }
        return properties;
    }

    public static void showError(Logger logger, String message, Throwable e, boolean showStackTrace) {
        if (showStackTrace) {
            logger.error(message, e);
        } else {
            logger.error(message);
            if (e != null) {
                logger.error(e.getMessage());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    logger.error("io.quarkus.launcher.shaded.Caused by: {}", (Object)cause.getMessage());
                }
            }
        }
    }

    public static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("io.quarkus.launcher.shaded.yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }

    public static String formatDuration(long duration) {
        long ms = duration % 1000L;
        long s = duration / 1000L % 60L;
        long m = duration / 60000L % 60L;
        long h = duration / 3600000L % 24L;
        long d = duration / 86400000L;
        String format = d > 0L ? "io.quarkus.launcher.shaded.%d d %02d:%02d h" : (h > 0L ? "io.quarkus.launcher.shaded.%2$02d:%3$02d h" : (m > 0L ? "io.quarkus.launcher.shaded.%3$02d:%4$02d min" : "io.quarkus.launcher.shaded.%4$d.%5$03d s"));
        return String.format(format, d, h, m, s, ms);
    }
}

