/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli.configuration;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.commons.cli.CommandLine;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.InvalidRepositoryException;
import io.quarkus.launcher.shaded.org.apache.maven.bridge.MavenRepositorySystem;
import io.quarkus.launcher.shaded.org.apache.maven.building.Source;
import io.quarkus.launcher.shaded.org.apache.maven.cli.CliRequest;
import io.quarkus.launcher.shaded.org.apache.maven.cli.ResolveFile;
import io.quarkus.launcher.shaded.org.apache.maven.cli.configuration.ConfigurationProcessor;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionRequestPopulationException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.SettingsUtils;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

@Named(value="io.quarkus.launcher.shaded.settings")
@Singleton
public class SettingsXmlConfigurationProcessor
implements ConfigurationProcessor {
    public static final String HINT = "io.quarkus.launcher.shaded.settings";
    public static final String USER_HOME = System.getProperty("io.quarkus.launcher.shaded.user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, "io.quarkus.launcher.shaded..m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "io.quarkus.launcher.shaded.settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("io.quarkus.launcher.shaded.maven.conf"), "io.quarkus.launcher.shaded.settings.xml");
    private final Logger logger = LoggerFactory.getLogger(SettingsXmlConfigurationProcessor.class);
    @Inject
    private SettingsBuilder settingsBuilder;
    @Inject
    private SettingsDecrypter settingsDecrypter;

    @Override
    public void process(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        CommandLine commandLine = cliRequest.getCommandLine();
        String workingDirectory = cliRequest.getWorkingDirectory();
        MavenExecutionRequest request = cliRequest.getRequest();
        if (commandLine.hasOption('s')) {
            userSettingsFile = new File(commandLine.getOptionValue('s'));
            if (!(userSettingsFile = ResolveFile.resolveFile(userSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("io.quarkus.launcher.shaded.The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        if (commandLine.hasOption("io.quarkus.launcher.shaded.gs")) {
            globalSettingsFile = new File(commandLine.getOptionValue("io.quarkus.launcher.shaded.gs"));
            if (!(globalSettingsFile = ResolveFile.resolveFile(globalSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("io.quarkus.launcher.shaded.The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        request.setGlobalSettingsFile(globalSettingsFile);
        request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.getSystemProperties());
        settingsRequest.setUserProperties(cliRequest.getUserProperties());
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent(settingsRequest);
        }
        this.logger.debug("io.quarkus.launcher.shaded.Reading global settings from {}", this.getLocation(settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsFile()));
        this.logger.debug("io.quarkus.launcher.shaded.Reading user settings from {}", this.getLocation(settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsFile()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build(settingsRequest);
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent(settingsResult);
        }
        this.populateFromSettings(request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn("io.quarkus.launcher.shaded.");
            this.logger.warn("io.quarkus.launcher.shaded.Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.logger.warn("io.quarkus.launcher.shaded.{} @ {}", (Object)problem.getMessage(), (Object)problem.getLocation());
            }
            this.logger.warn("io.quarkus.launcher.shaded.");
        }
    }

    private MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenExecutionRequestPopulationException {
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            server = server.clone();
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            proxy = proxy.clone();
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            mirror = mirror.clone();
            request.addMirror(mirror);
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile(rawProfile));
            if (!settings.getActiveProfiles().contains(rawProfile.getId())) continue;
            List<Repository> remoteRepositories = rawProfile.getRepositories();
            for (Repository remoteRepository : remoteRepositories) {
                try {
                    request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository(remoteRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
            List<Repository> pluginRepositories = rawProfile.getPluginRepositories();
            for (Repository pluginRepository : pluginRepositories) {
                try {
                    request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository(pluginRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
        }
        return request;
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }
}

