/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli.event;

import io.quarkus.launcher.shaded.org.apache.maven.cli.CLIReportingUtils;
import io.quarkus.launcher.shaded.org.apache.maven.execution.AbstractExecutionListener;
import io.quarkus.launcher.shaded.org.apache.maven.execution.BuildFailure;
import io.quarkus.launcher.shaded.org.apache.maven.execution.BuildSuccess;
import io.quarkus.launcher.shaded.org.apache.maven.execution.BuildSummary;
import io.quarkus.launcher.shaded.org.apache.maven.execution.ExecutionEvent;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionResult;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.logging.MessageBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.logging.MessageUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Objects;

public class ExecutionEventLogger
extends AbstractExecutionListener {
    private final Logger logger;
    private static final int LINE_LENGTH = 72;
    private static final int MAX_PADDED_BUILD_TIME_DURATION_LENGTH = 9;
    private static final int MAX_PROJECT_NAME_LENGTH = 52;
    private int totalProjects;
    private volatile int currentVisitedProjectCount;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
    }

    public ExecutionEventLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "io.quarkus.launcher.shaded.logger cannot be null");
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    private void infoLine(char c) {
        this.infoMain(ExecutionEventLogger.chars(c, 72));
    }

    private void infoMain(String msg) {
        this.logger.info(MessageUtils.buffer().strong(msg).toString());
    }

    @Override
    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("io.quarkus.launcher.shaded.Scanning for projects...");
        }
    }

    @Override
    public void sessionStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getSession().getProjects().size() > 1) {
            this.infoLine('-');
            this.infoMain("io.quarkus.launcher.shaded.Reactor Build Order:");
            this.logger.info("io.quarkus.launcher.shaded.");
            List<MavenProject> projects = event.getSession().getProjects();
            for (MavenProject project : projects) {
                int len = 72 - project.getName().length() - project.getPackaging().length() - 2;
                this.logger.info("io.quarkus.launcher.shaded.{}{}[{}]", project.getName(), ExecutionEventLogger.chars(' ', len > 0 ? len : 1), project.getPackaging());
            }
            this.totalProjects = projects.size();
        }
    }

    @Override
    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.infoLine('-');
        }
    }

    private boolean isSingleVersionedReactor(MavenSession session) {
        boolean result = true;
        MavenProject topProject = session.getTopLevelProject();
        List<MavenProject> sortedProjects = session.getProjectDependencyGraph().getSortedProjects();
        for (MavenProject mavenProject : sortedProjects) {
            if (topProject.getVersion().equals(mavenProject.getVersion())) continue;
            result = false;
            break;
        }
        return result;
    }

    private void logReactorSummary(MavenSession session) {
        boolean isSingleVersion = this.isSingleVersionedReactor(session);
        this.infoLine('-');
        StringBuilder summary = new StringBuilder("io.quarkus.launcher.shaded.Reactor Summary");
        if (isSingleVersion) {
            summary.append("io.quarkus.launcher.shaded. for ");
            summary.append(session.getTopLevelProject().getName());
            summary.append("io.quarkus.launcher.shaded. ");
            summary.append(session.getTopLevelProject().getVersion());
        }
        summary.append("io.quarkus.launcher.shaded.:");
        this.infoMain(summary.toString());
        this.logger.info("io.quarkus.launcher.shaded.");
        MavenExecutionResult result = session.getResult();
        List<MavenProject> projects = session.getProjects();
        for (MavenProject project : projects) {
            int padSize;
            String buildTimeDuration;
            BuildSummary buildSummary;
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(project.getName());
            buffer.append(' ');
            if (!isSingleVersion) {
                buffer.append(project.getVersion());
                buffer.append(' ');
            }
            if (buffer.length() <= 52) {
                while (buffer.length() < 52) {
                    buffer.append('.');
                }
                buffer.append(' ');
            }
            if ((buildSummary = result.getBuildSummary(project)) == null) {
                buffer.append(MessageUtils.buffer().warning("io.quarkus.launcher.shaded.SKIPPED"));
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append(MessageUtils.buffer().success("io.quarkus.launcher.shaded.SUCCESS"));
                buffer.append("io.quarkus.launcher.shaded. [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append(MessageUtils.buffer().failure("io.quarkus.launcher.shaded.FAILURE"));
                buffer.append("io.quarkus.launcher.shaded. [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            }
            this.logger.info(buffer.toString());
        }
    }

    private void logResult(MavenSession session) {
        this.infoLine('-');
        MessageBuilder buffer = MessageUtils.buffer();
        if (session.getResult().hasExceptions()) {
            buffer.failure("io.quarkus.launcher.shaded.BUILD FAILURE");
        } else {
            buffer.success("io.quarkus.launcher.shaded.BUILD SUCCESS");
        }
        this.logger.info(buffer.toString());
    }

    private void logStats(MavenSession session) {
        this.infoLine('-');
        long finish = System.currentTimeMillis();
        long time = finish - session.getRequest().getStartTime().getTime();
        String wallClock = session.getRequest().getDegreeOfConcurrency() > 1 ? "io.quarkus.launcher.shaded. (Wall Clock)" : "io.quarkus.launcher.shaded.";
        this.logger.info("io.quarkus.launcher.shaded.Total time:  {}{}", (Object)CLIReportingUtils.formatDuration(time), (Object)wallClock);
        this.logger.info("io.quarkus.launcher.shaded.Finished at: {}", (Object)CLIReportingUtils.formatTimestamp(finish));
    }

    @Override
    public void projectSkipped(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("io.quarkus.launcher.shaded.");
            this.infoLine('-');
            this.infoMain("io.quarkus.launcher.shaded.Skipping " + event.getProject().getName());
            this.logger.info("io.quarkus.launcher.shaded.This project has been banned from the build due to previous failures.");
            this.infoLine('-');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            MavenProject project = event.getProject();
            this.logger.info("io.quarkus.launcher.shaded.");
            String projectKey = project.getGroupId() + ':' + project.getArtifactId();
            String preHeader = "io.quarkus.launcher.shaded.--< ";
            String postHeader = "io.quarkus.launcher.shaded. >--";
            int headerLen = "io.quarkus.launcher.shaded.--< ".length() + projectKey.length() + "io.quarkus.launcher.shaded. >--".length();
            String prefix = ExecutionEventLogger.chars('-', Math.max(0, (72 - headerLen) / 2)) + "io.quarkus.launcher.shaded.--< ";
            String suffix = "io.quarkus.launcher.shaded. >--" + ExecutionEventLogger.chars('-', Math.max(0, 72 - headerLen - prefix.length() + "io.quarkus.launcher.shaded.--< ".length()));
            this.logger.info(MessageUtils.buffer().strong(prefix).project(projectKey).strong(suffix).toString());
            String building = "io.quarkus.launcher.shaded.Building " + event.getProject().getName() + "io.quarkus.launcher.shaded. " + event.getProject().getVersion();
            if (this.totalProjects <= 1) {
                this.infoMain(building);
            } else {
                int number;
                ExecutionEventLogger executionEventLogger = this;
                synchronized (executionEventLogger) {
                    number = ++this.currentVisitedProjectCount;
                }
                String progress = "io.quarkus.launcher.shaded. [" + number + '/' + this.totalProjects + ']';
                int pad = 72 - building.length() - progress.length();
                this.infoMain(building + (pad > 0 ? ExecutionEventLogger.chars(' ', pad) : "io.quarkus.launcher.shaded.") + progress);
            }
            prefix = ExecutionEventLogger.chars('-', Math.max(0, (72 - project.getPackaging().length() - 4) / 2));
            suffix = ExecutionEventLogger.chars('-', Math.max(0, 72 - project.getPackaging().length() - 4 - prefix.length()));
            this.infoMain(prefix + "io.quarkus.launcher.shaded.[ " + project.getPackaging() + "io.quarkus.launcher.shaded. ]" + suffix);
        }
    }

    @Override
    public void mojoSkipped(ExecutionEvent event) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("io.quarkus.launcher.shaded.Goal {} requires online mode for execution but Maven is currently offline, skipping", (Object)event.getMojoExecution().getGoal());
        }
    }

    @Override
    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("io.quarkus.launcher.shaded.");
            MessageBuilder buffer = MessageUtils.buffer().strong("io.quarkus.launcher.shaded.--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.strong("io.quarkus.launcher.shaded. ---");
            this.logger.info(buffer.toString());
        }
    }

    @Override
    public void forkStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("io.quarkus.launcher.shaded.");
            MessageBuilder buffer = MessageUtils.buffer().strong("io.quarkus.launcher.shaded.>>> ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong("io.quarkus.launcher.shaded. > ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong("io.quarkus.launcher.shaded. >>>");
            this.logger.info(buffer.toString());
        }
    }

    @Override
    public void forkSucceeded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("io.quarkus.launcher.shaded.");
            MessageBuilder buffer = MessageUtils.buffer().strong("io.quarkus.launcher.shaded.<<< ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong("io.quarkus.launcher.shaded. < ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong("io.quarkus.launcher.shaded. <<<");
            this.logger.info(buffer.toString());
            this.logger.info("io.quarkus.launcher.shaded.");
        }
    }

    private void append(MessageBuilder buffer, MojoExecution me) {
        buffer.mojo(me.getArtifactId() + ':' + me.getVersion() + ':' + me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.a(Character.valueOf(' ')).strong('(' + me.getExecutionId() + ')');
        }
    }

    private void appendForkInfo(MessageBuilder buffer, MojoDescriptor md) {
        StringBuilder buff = new StringBuilder();
        if (StringUtils.isNotEmpty(md.getExecutePhase())) {
            if (StringUtils.isNotEmpty(md.getExecuteLifecycle())) {
                buff.append('[');
                buff.append(md.getExecuteLifecycle());
                buff.append(']');
            }
            buff.append(md.getExecutePhase());
        } else {
            buff.append(':');
            buff.append(md.getExecuteGoal());
        }
        buffer.strong(buff.toString());
    }

    private void append(MessageBuilder buffer, MavenProject project) {
        buffer.a("io.quarkus.launcher.shaded. @ ").project(project.getArtifactId());
    }

    @Override
    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getMojoExecution().getForkedExecutions().size() > 1) {
            this.logger.info("io.quarkus.launcher.shaded.");
            this.infoLine('>');
            this.infoMain("io.quarkus.launcher.shaded.Forking " + event.getProject().getName() + "io.quarkus.launcher.shaded. " + event.getProject().getVersion());
            this.infoLine('>');
        }
    }
}

