/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli.internal;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.cli.internal.extension.model.CoreExtension;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.extension.internal.CoreExtensionEntry;
import io.quarkus.launcher.shaded.org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import io.quarkus.launcher.shaded.org.codehaus.plexus.DefaultPlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.ClassWorld;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyNode;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Named
public class BootstrapCoreExtensionManager {
    private final Logger log;
    private final DefaultPluginDependenciesResolver pluginDependenciesResolver;
    private final DefaultRepositorySystemSessionFactory repositorySystemSessionFactory;
    private final ClassWorld classWorld;
    private final ClassRealm parentRealm;

    @Inject
    public BootstrapCoreExtensionManager(Logger log, DefaultPluginDependenciesResolver pluginDependenciesResolver, DefaultRepositorySystemSessionFactory repositorySystemSessionFactory, PlexusContainer container) {
        this.log = log;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.repositorySystemSessionFactory = repositorySystemSessionFactory;
        this.classWorld = ((DefaultPlexusContainer)container).getClassWorld();
        this.parentRealm = container.getContainerRealm();
    }

    public List<CoreExtensionEntry> loadCoreExtensions(MavenExecutionRequest request, Set<String> providedArtifacts, List<CoreExtension> extensions) throws Exception {
        DefaultRepositorySystemSession repoSession = this.repositorySystemSessionFactory.newRepositorySession(request);
        List<RemoteRepository> repositories = RepositoryUtils.toRepos(request.getPluginArtifactRepositories());
        return this.resolveCoreExtensions(repoSession, repositories, providedArtifacts, extensions);
    }

    private List<CoreExtensionEntry> resolveCoreExtensions(RepositorySystemSession repoSession, List<RemoteRepository> repositories, Set<String> providedArtifacts, List<CoreExtension> configuration) throws Exception {
        ArrayList<CoreExtensionEntry> extensions = new ArrayList<CoreExtensionEntry>();
        ExclusionsDependencyFilter dependencyFilter = new ExclusionsDependencyFilter(providedArtifacts);
        for (CoreExtension extension : configuration) {
            List<Artifact> artifacts = this.resolveExtension(extension, repoSession, repositories, dependencyFilter);
            if (artifacts.isEmpty()) continue;
            extensions.add(this.createExtension(extension, artifacts));
        }
        return Collections.unmodifiableList(extensions);
    }

    private CoreExtensionEntry createExtension(CoreExtension extension, List<Artifact> artifacts) throws Exception {
        String realmId = "io.quarkus.launcher.shaded.coreExtension>" + extension.getGroupId() + "io.quarkus.launcher.shaded.:" + extension.getArtifactId() + "io.quarkus.launcher.shaded.:" + extension.getVersion();
        ClassRealm realm = this.classWorld.newRealm(realmId, null);
        this.log.debug("io.quarkus.launcher.shaded.Populating class realm " + realm.getId());
        realm.setParentRealm(this.parentRealm);
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            this.log.debug("io.quarkus.launcher.shaded.  Included " + file);
            realm.addURL(file.toURI().toURL());
        }
        return CoreExtensionEntry.discoverFrom(realm, Collections.singleton(artifacts.get(0).getFile()));
    }

    private List<Artifact> resolveExtension(CoreExtension extension, RepositorySystemSession repoSession, List<RemoteRepository> repositories, DependencyFilter dependencyFilter) throws PluginResolutionException {
        Plugin plugin = new Plugin();
        plugin.setGroupId(extension.getGroupId());
        plugin.setArtifactId(extension.getArtifactId());
        plugin.setVersion(extension.getVersion());
        DependencyNode root = this.pluginDependenciesResolver.resolveCoreExtension(plugin, dependencyFilter, repositories, repoSession);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept(nlg);
        List artifacts = nlg.getArtifacts(false);
        return artifacts;
    }
}

