/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli.logging.impl;

import io.quarkus.launcher.shaded.org.apache.maven.cli.logging.BaseSlf4jConfiguration;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.net.URL;
import java.util.Map;
import java.util.Set;

public class UnsupportedSlf4jBindingConfiguration
extends BaseSlf4jConfiguration {
    private final Logger logger = LoggerFactory.getLogger(UnsupportedSlf4jBindingConfiguration.class);
    private String slf4jBinding;
    private Map<URL, Set<Object>> supported;

    public UnsupportedSlf4jBindingConfiguration(String slf4jBinding, Map<URL, Set<Object>> supported) {
        this.slf4jBinding = slf4jBinding;
        this.supported = supported;
    }

    @Override
    public void activate() {
        this.logger.warn("io.quarkus.launcher.shaded.The SLF4J binding actually used is not supported by Maven: {}", (Object)this.slf4jBinding);
        this.logger.warn("io.quarkus.launcher.shaded.Maven supported bindings are:");
        String ls = System.getProperty("io.quarkus.launcher.shaded.line.separator");
        for (Map.Entry<URL, Set<Object>> entry : this.supported.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("io.quarkus.launcher.shaded.(from ").append(entry.getKey().toExternalForm()).append(')');
            for (Object binding : entry.getValue()) {
                sb.append(ls).append("io.quarkus.launcher.shaded.- ").append(binding);
            }
            this.logger.warn(sb.toString());
        }
    }
}

