/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli.transfer;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.Validate;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.AbstractTransferListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferCancelledException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferResource;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public abstract class AbstractMavenTransferListener
extends AbstractTransferListener {
    protected PrintStream out;

    protected AbstractMavenTransferListener(PrintStream out) {
        this.out = out;
    }

    @Override
    public void transferInitiated(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.Uploading" : "io.quarkus.launcher.shaded.Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.to" : "io.quarkus.launcher.shaded.from";
        TransferResource resource = event.getResource();
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append("io.quarkus.launcher.shaded.: ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        this.out.println(message.toString());
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.println("io.quarkus.launcher.shaded.[WARNING] " + event.getException().getMessage() + "io.quarkus.launcher.shaded. from " + resource.getRepositoryId() + "io.quarkus.launcher.shaded. for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.Uploaded" : "io.quarkus.launcher.shaded.Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.to" : "io.quarkus.launcher.shaded.from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        FileSizeFormat format = new FileSizeFormat(Locale.ENGLISH);
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append("io.quarkus.launcher.shaded.: ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        message.append("io.quarkus.launcher.shaded. (").append(format.format(contentLength));
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            message.append("io.quarkus.launcher.shaded. at ").append(format.format((long)bytesPerSecond)).append("io/quarkus/launcher/shaded//s");
        }
        message.append(')');
        this.out.println(message.toString());
    }

    static class FileSizeFormat {
        private DecimalFormat smallFormat;
        private DecimalFormat largeFormat;

        FileSizeFormat(Locale locale) {
            this.smallFormat = new DecimalFormat("io.quarkus.launcher.shaded.#0.0", new DecimalFormatSymbols(locale));
            this.largeFormat = new DecimalFormat("io.quarkus.launcher.shaded.###0", new DecimalFormatSymbols(locale));
        }

        public String format(long size) {
            return this.format(size, null);
        }

        public String format(long size, ScaleUnit unit) {
            return this.format(size, unit, false);
        }

        public String format(long size, ScaleUnit unit, boolean omitSymbol) {
            Validate.isTrue(size >= 0L, "io.quarkus.launcher.shaded.file size cannot be negative: %s", size);
            if (unit == null) {
                unit = ScaleUnit.getScaleUnit(size);
            }
            double scaledSize = (double)size / (double)unit.bytes();
            String scaledSymbol = "io.quarkus.launcher.shaded. " + unit.symbol();
            if (omitSymbol) {
                scaledSymbol = "io.quarkus.launcher.shaded.";
            }
            if (unit == ScaleUnit.BYTE) {
                return this.largeFormat.format(size) + scaledSymbol;
            }
            if (scaledSize < 0.05 || scaledSize >= 10.0) {
                return this.largeFormat.format(scaledSize) + scaledSymbol;
            }
            return this.smallFormat.format(scaledSize) + scaledSymbol;
        }

        public String formatProgress(long progressedSize, long size) {
            Validate.isTrue(progressedSize >= 0L, "io.quarkus.launcher.shaded.progressed file size cannot be negative: %s", progressedSize);
            Validate.isTrue(size >= 0L && progressedSize <= size || size < 0L, "io.quarkus.launcher.shaded.progressed file size cannot be greater than size: %s > %s", progressedSize, size);
            if (size >= 0L && progressedSize != size) {
                ScaleUnit unit = ScaleUnit.getScaleUnit(size);
                String formattedProgressedSize = this.format(progressedSize, unit, true);
                String formattedSize = this.format(size, unit);
                return formattedProgressedSize + "io/quarkus/launcher/shaded//" + formattedSize;
            }
            return this.format(progressedSize);
        }

        static enum ScaleUnit {
            BYTE{

                @Override
                public long bytes() {
                    return 1L;
                }

                @Override
                public String symbol() {
                    return "io.quarkus.launcher.shaded.B";
                }
            }
            ,
            KILOBYTE{

                @Override
                public long bytes() {
                    return 1000L;
                }

                @Override
                public String symbol() {
                    return "io.quarkus.launcher.shaded.kB";
                }
            }
            ,
            MEGABYTE{

                @Override
                public long bytes() {
                    return KILOBYTE.bytes() * KILOBYTE.bytes();
                }

                @Override
                public String symbol() {
                    return "io.quarkus.launcher.shaded.MB";
                }
            }
            ,
            GIGABYTE{

                @Override
                public long bytes() {
                    return MEGABYTE.bytes() * KILOBYTE.bytes();
                }

                @Override
                public String symbol() {
                    return "io.quarkus.launcher.shaded.GB";
                }
            };


            public abstract long bytes();

            public abstract String symbol();

            public static ScaleUnit getScaleUnit(long size) {
                Validate.isTrue(size >= 0L, "io.quarkus.launcher.shaded.file size cannot be negative: %s", size);
                if (size >= GIGABYTE.bytes()) {
                    return GIGABYTE;
                }
                if (size >= MEGABYTE.bytes()) {
                    return MEGABYTE;
                }
                if (size >= KILOBYTE.bytes()) {
                    return KILOBYTE;
                }
                return BYTE;
            }
        }
    }
}

