/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.cli.transfer;

import io.quarkus.launcher.shaded.org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.AbstractTransferListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferCancelledException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferResource;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.Locale;

public class Slf4jMavenTransferListener
extends AbstractTransferListener {
    protected final Logger out;

    public Slf4jMavenTransferListener() {
        this.out = LoggerFactory.getLogger(Slf4jMavenTransferListener.class);
    }

    public Slf4jMavenTransferListener(Logger out) {
        this.out = out;
    }

    @Override
    public void transferInitiated(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.Uploading" : "io.quarkus.launcher.shaded.Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.to" : "io.quarkus.launcher.shaded.from";
        TransferResource resource = event.getResource();
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append("io.quarkus.launcher.shaded.: ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        this.out.info(message.toString());
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.warn("io.quarkus.launcher.shaded.{} from {} for {}{}", event.getException().getMessage(), resource.getRepositoryId(), resource.getRepositoryUrl(), resource.getResourceName());
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.Uploaded" : "io.quarkus.launcher.shaded.Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "io.quarkus.launcher.shaded.to" : "io.quarkus.launcher.shaded.from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        AbstractMavenTransferListener.FileSizeFormat format = new AbstractMavenTransferListener.FileSizeFormat(Locale.ENGLISH);
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append("io.quarkus.launcher.shaded.: ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        message.append("io.quarkus.launcher.shaded. (").append(format.format(contentLength));
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            message.append("io.quarkus.launcher.shaded. at ").append(format.format((long)bytesPerSecond)).append("io/quarkus/launcher/shaded//s");
        }
        message.append(')');
        this.out.info(message.toString());
    }
}

