/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.configuration.internal;

import io.quarkus.launcher.shaded.org.apache.maven.configuration.BeanConfigurationException;
import io.quarkus.launcher.shaded.org.apache.maven.configuration.BeanConfigurationPathTranslator;
import io.quarkus.launcher.shaded.org.apache.maven.configuration.BeanConfigurationRequest;
import io.quarkus.launcher.shaded.org.apache.maven.configuration.BeanConfigurationValuePreprocessor;
import io.quarkus.launcher.shaded.org.apache.maven.configuration.BeanConfigurator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import java.io.File;
import java.util.Objects;

@Component(role=BeanConfigurator.class)
public class DefaultBeanConfigurator
implements BeanConfigurator {
    private final ConverterLookup converterLookup = new DefaultConverterLookup();

    @Override
    public void configureBean(BeanConfigurationRequest request) throws BeanConfigurationException {
        ClassLoader classLoader;
        PlexusConfiguration plexusConfig;
        Objects.requireNonNull(request, "io.quarkus.launcher.shaded.request cannot be null");
        Objects.requireNonNull(request.getBean(), "io.quarkus.launcher.shaded.request.bean cannot be null");
        Object configuration = request.getConfiguration();
        if (configuration == null) {
            return;
        }
        if (configuration instanceof PlexusConfiguration) {
            plexusConfig = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            plexusConfig = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        } else {
            throw new BeanConfigurationException("io.quarkus.launcher.shaded.unsupported bean configuration source (" + configuration.getClass().getName() + "io.quarkus.launcher.shaded.)");
        }
        if (request.getConfigurationElement() != null) {
            plexusConfig = plexusConfig.getChild(request.getConfigurationElement());
        }
        if ((classLoader = request.getClassLoader()) == null) {
            classLoader = request.getBean().getClass().getClassLoader();
        }
        BeanExpressionEvaluator evaluator = new BeanExpressionEvaluator(request);
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
        try {
            converter.processConfiguration(this.converterLookup, request.getBean(), classLoader, plexusConfig, evaluator);
        }
        catch (ComponentConfigurationException e) {
            throw new BeanConfigurationException(e.getMessage(), e);
        }
    }

    static class BeanExpressionEvaluator
    implements TypeAwareExpressionEvaluator {
        private final BeanConfigurationValuePreprocessor preprocessor;
        private final BeanConfigurationPathTranslator translator;

        BeanExpressionEvaluator(BeanConfigurationRequest request) {
            this.preprocessor = request.getValuePreprocessor();
            this.translator = request.getPathTranslator();
        }

        @Override
        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            if (this.preprocessor != null) {
                try {
                    return this.preprocessor.preprocessValue(expression, type);
                }
                catch (BeanConfigurationException e) {
                    throw new ExpressionEvaluationException(e.getMessage(), e);
                }
            }
            return expression;
        }

        @Override
        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        @Override
        public File alignToBaseDirectory(File file) {
            if (this.translator != null) {
                return this.translator.translatePath(file);
            }
            return file;
        }
    }
}

