/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.eventspy.internal;

import io.quarkus.launcher.shaded.org.apache.maven.eventspy.EventSpy;
import io.quarkus.launcher.shaded.org.apache.maven.eventspy.internal.EventSpyExecutionListener;
import io.quarkus.launcher.shaded.org.apache.maven.eventspy.internal.EventSpyRepositoryListener;
import io.quarkus.launcher.shaded.org.apache.maven.execution.ExecutionListener;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryListener;
import java.util.ArrayList;
import java.util.List;

@Component(role=EventSpyDispatcher.class)
public class EventSpyDispatcher {
    @Requirement
    private Logger logger;
    @Requirement(role=EventSpy.class)
    private List<EventSpy> eventSpies;

    public void setEventSpies(List<EventSpy> eventSpies) {
        this.eventSpies = new ArrayList<EventSpy>(eventSpies);
    }

    public List<EventSpy> getEventSpies() {
        return this.eventSpies;
    }

    public ExecutionListener chainListener(ExecutionListener listener) {
        if (this.eventSpies.isEmpty()) {
            return listener;
        }
        return new EventSpyExecutionListener(this, listener);
    }

    public RepositoryListener chainListener(RepositoryListener listener) {
        if (this.eventSpies.isEmpty()) {
            return listener;
        }
        return new EventSpyRepositoryListener(this, listener);
    }

    public void init(EventSpy.Context context) {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.init(context);
            }
            catch (Exception | LinkageError e) {
                this.logError("io.quarkus.launcher.shaded.initialize", e, eventSpy);
            }
        }
    }

    public void onEvent(Object event) {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.onEvent(event);
            }
            catch (Exception | LinkageError e) {
                this.logError("io.quarkus.launcher.shaded.notify", e, eventSpy);
            }
        }
    }

    public void close() {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.close();
            }
            catch (Exception | LinkageError e) {
                this.logError("io.quarkus.launcher.shaded.close", e, eventSpy);
            }
        }
    }

    private void logError(String action, Throwable e, EventSpy spy) {
        String msg = "io.quarkus.launcher.shaded.Failed to " + action + "io.quarkus.launcher.shaded. spy " + spy.getClass().getName() + "io.quarkus.launcher.shaded.: " + e.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, e);
        } else {
            this.logger.warn(msg);
        }
    }
}

