/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.exception;

import io.quarkus.launcher.shaded.org.apache.maven.exception.ExceptionHandler;
import io.quarkus.launcher.shaded.org.apache.maven.exception.ExceptionSummary;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblem;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemUtils;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.AbstractMojoExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoFailureException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginContainerException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectBuildingResult;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

@Component(role=ExceptionHandler.class)
public class DefaultExceptionHandler
implements ExceptionHandler {
    @Override
    public ExceptionSummary handleException(Throwable exception) {
        return this.handle("io.quarkus.launcher.shaded.", exception);
    }

    private ExceptionSummary handle(String message, Throwable exception) {
        String reference = this.getReference(exception);
        ArrayList<ExceptionSummary> children = null;
        if (exception instanceof ProjectBuildingException) {
            List<ProjectBuildingResult> results = ((ProjectBuildingException)exception).getResults();
            children = new ArrayList<ExceptionSummary>();
            for (ProjectBuildingResult result : results) {
                ExceptionSummary child = this.handle(result);
                if (child == null) continue;
                children.add(child);
            }
            message = "io.quarkus.launcher.shaded.The build could not read " + children.size() + "io.quarkus.launcher.shaded. project" + (children.size() == 1 ? "io.quarkus.launcher.shaded." : "io.quarkus.launcher.shaded.s");
        } else {
            message = this.getMessage(message, exception);
        }
        return new ExceptionSummary(exception, message, reference, children);
    }

    private ExceptionSummary handle(ProjectBuildingResult result) {
        ArrayList<ExceptionSummary> children = new ArrayList<ExceptionSummary>();
        for (ModelProblem problem : result.getProblems()) {
            ExceptionSummary child = this.handle(problem, result.getProjectId());
            if (child == null) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            return null;
        }
        String message = "io.quarkus.launcher.shaded.\nThe project " + result.getProjectId() + "io.quarkus.launcher.shaded. (" + result.getPomFile() + "io.quarkus.launcher.shaded.) has " + children.size() + "io.quarkus.launcher.shaded. error" + (children.size() == 1 ? "io.quarkus.launcher.shaded." : "io.quarkus.launcher.shaded.s");
        return new ExceptionSummary(null, message, null, children);
    }

    private ExceptionSummary handle(ModelProblem problem, String projectId) {
        if (ModelProblem.Severity.ERROR.compareTo(problem.getSeverity()) >= 0) {
            String message = problem.getMessage();
            String location = ModelProblemUtils.formatLocation(problem, projectId);
            if (StringUtils.isNotEmpty(location)) {
                message = message + "io.quarkus.launcher.shaded. @ " + location;
            }
            return this.handle(message, problem.getException());
        }
        return null;
    }

    private String getReference(Throwable exception) {
        String reference = "io.quarkus.launcher.shaded.";
        if (exception != null) {
            if (exception instanceof MojoExecutionException) {
                reference = MojoExecutionException.class.getSimpleName();
                Throwable cause = exception.getCause();
                if (cause instanceof IOException && (cause = cause.getCause()) instanceof ConnectException) {
                    reference = ConnectException.class.getSimpleName();
                }
            } else if (exception instanceof MojoFailureException) {
                reference = MojoFailureException.class.getSimpleName();
            } else if (exception instanceof LinkageError) {
                reference = LinkageError.class.getSimpleName();
            } else if (exception instanceof PluginExecutionException) {
                String message;
                Throwable cause2;
                Throwable cause = exception.getCause();
                if (cause instanceof PluginContainerException && (cause2 = cause.getCause()) instanceof NoClassDefFoundError && (message = cause2.getMessage()) != null && message.contains("io/quarkus/launcher/shaded/org/sonatype/aether/")) {
                    reference = "io.quarkus.launcher.shaded.AetherClassNotFound";
                }
                if (StringUtils.isEmpty(reference)) {
                    reference = this.getReference(cause);
                }
                if (StringUtils.isEmpty(reference)) {
                    reference = exception.getClass().getSimpleName();
                }
            } else if (exception instanceof LifecycleExecutionException) {
                reference = this.getReference(exception.getCause());
            } else if (this.isNoteworthyException(exception)) {
                reference = exception.getClass().getSimpleName();
            }
        }
        if (StringUtils.isNotEmpty(reference) && !reference.startsWith("io.quarkus.launcher.shaded.http:")) {
            reference = "io/quarkus/launcher/shaded/http://cwiki.apache.org/confluence/display/MAVEN/" + reference;
        }
        return reference;
    }

    private boolean isNoteworthyException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof Error) {
            return true;
        }
        if (exception instanceof RuntimeException) {
            return false;
        }
        return !exception.getClass().getName().startsWith("java");
    }

    private String getMessage(String message, Throwable exception) {
        String fullMessage = message != null ? message : "io.quarkus.launcher.shaded.";
        for (Throwable t = exception; t != null; t = t.getCause()) {
            String longMessage;
            String exceptionMessage = t.getMessage();
            if (t instanceof AbstractMojoExecutionException && StringUtils.isNotEmpty(longMessage = ((AbstractMojoExecutionException)t).getLongMessage())) {
                if (StringUtils.isEmpty(exceptionMessage) || longMessage.contains(exceptionMessage)) {
                    exceptionMessage = longMessage;
                } else if (!exceptionMessage.contains(longMessage)) {
                    exceptionMessage = this.join(exceptionMessage, '\n' + longMessage);
                }
            }
            if (StringUtils.isEmpty(exceptionMessage)) {
                exceptionMessage = t.getClass().getSimpleName();
            }
            if (t instanceof UnknownHostException && !fullMessage.contains("io.quarkus.launcher.shaded.host")) {
                fullMessage = this.join(fullMessage, "io.quarkus.launcher.shaded.Unknown host " + exceptionMessage);
                continue;
            }
            if (fullMessage.contains(exceptionMessage)) continue;
            fullMessage = this.join(fullMessage, exceptionMessage);
        }
        return fullMessage.trim();
    }

    private String join(String message1, String message2) {
        String message = "io.quarkus.launcher.shaded.";
        if (StringUtils.isNotEmpty(message1)) {
            message = message1.trim();
        }
        if (StringUtils.isNotEmpty(message2)) {
            if (StringUtils.isNotEmpty(message)) {
                message = message.endsWith("io.quarkus.launcher.shaded..") || message.endsWith("io.quarkus.launcher.shaded.!") || message.endsWith("io.quarkus.launcher.shaded.:") ? message + "io.quarkus.launcher.shaded. " : message + "io.quarkus.launcher.shaded.: ";
            }
            message = message + message2;
        }
        return message;
    }
}

