/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.execution;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.ArtifactUtils;
import io.quarkus.launcher.shaded.org.apache.maven.execution.BuildFailure;
import io.quarkus.launcher.shaded.org.apache.maven.execution.BuildSuccess;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.DuplicateProjectException;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.apache.maven.project.ProjectSorter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.dag.CycleDetectedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class ReactorManager {
    public static final String FAIL_FAST = "io.quarkus.launcher.shaded.fail-fast";
    public static final String FAIL_AT_END = "io.quarkus.launcher.shaded.fail-at-end";
    public static final String FAIL_NEVER = "io.quarkus.launcher.shaded.fail-never";
    public static final String MAKE_MODE = "io.quarkus.launcher.shaded.make";
    public static final String MAKE_DEPENDENTS_MODE = "io.quarkus.launcher.shaded.make-dependents";
    public static final String MAKE_BOTH_MODE = "io.quarkus.launcher.shaded.make-both";
    private List<String> blackList = new ArrayList<String>();
    private Map<String, BuildFailure> buildFailuresByProject = new HashMap<String, BuildFailure>();
    private Map<String, Map<String, Map>> pluginContextsByProjectAndPluginKey = new HashMap<String, Map<String, Map>>();
    private String failureBehavior = "io.quarkus.launcher.shaded.fail-fast";
    private final ProjectSorter sorter;
    private Map<String, BuildSuccess> buildSuccessesByProject = new HashMap<String, BuildSuccess>();

    public ReactorManager(List<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.sorter = new ProjectSorter(projects);
    }

    public Map getPluginContext(PluginDescriptor plugin, MavenProject project) {
        HashMap pluginContext;
        Map<String, Map> pluginContextsByKey = this.pluginContextsByProjectAndPluginKey.get(project.getId());
        if (pluginContextsByKey == null) {
            pluginContextsByKey = new HashMap<String, Map>();
            this.pluginContextsByProjectAndPluginKey.put(project.getId(), pluginContextsByKey);
        }
        if ((pluginContext = pluginContextsByKey.get(plugin.getPluginLookupKey())) == null) {
            pluginContext = new HashMap();
            pluginContextsByKey.put(plugin.getPluginLookupKey(), pluginContext);
        }
        return pluginContext;
    }

    public void setFailureBehavior(String failureBehavior) {
        if (failureBehavior == null) {
            this.failureBehavior = FAIL_FAST;
            return;
        }
        if (!(FAIL_FAST.equals(failureBehavior) || FAIL_AT_END.equals(failureBehavior) || FAIL_NEVER.equals(failureBehavior))) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.Invalid failure behavior (must be one of: 'fail-fast', 'fail-at-end', 'fail-never').");
        }
        this.failureBehavior = failureBehavior;
    }

    public String getFailureBehavior() {
        return this.failureBehavior;
    }

    public void blackList(MavenProject project) {
        this.blackList(ReactorManager.getProjectKey(project));
    }

    private void blackList(String id) {
        if (!this.blackList.contains(id)) {
            this.blackList.add(id);
            List<String> dependents = this.sorter.getDependents(id);
            if (dependents != null && !dependents.isEmpty()) {
                for (String dependentId : dependents) {
                    if (this.buildSuccessesByProject.containsKey(dependentId) || this.buildFailuresByProject.containsKey(dependentId)) continue;
                    this.blackList(dependentId);
                }
            }
        }
    }

    public boolean isBlackListed(MavenProject project) {
        return this.blackList.contains(ReactorManager.getProjectKey(project));
    }

    private static String getProjectKey(MavenProject project) {
        return ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
    }

    public void registerBuildFailure(MavenProject project, Exception error, String task, long time) {
        this.buildFailuresByProject.put(ReactorManager.getProjectKey(project), new BuildFailure(project, time, error));
    }

    public boolean hasBuildFailures() {
        return !this.buildFailuresByProject.isEmpty();
    }

    public boolean hasBuildFailure(MavenProject project) {
        return this.buildFailuresByProject.containsKey(ReactorManager.getProjectKey(project));
    }

    public boolean hasMultipleProjects() {
        return this.sorter.hasMultipleProjects();
    }

    public List<MavenProject> getSortedProjects() {
        return this.sorter.getSortedProjects();
    }

    public boolean hasBuildSuccess(MavenProject project) {
        return this.buildSuccessesByProject.containsKey(ReactorManager.getProjectKey(project));
    }

    public void registerBuildSuccess(MavenProject project, long time) {
        this.buildSuccessesByProject.put(ReactorManager.getProjectKey(project), new BuildSuccess(project, time));
    }

    public BuildFailure getBuildFailure(MavenProject project) {
        return this.buildFailuresByProject.get(ReactorManager.getProjectKey(project));
    }

    public BuildSuccess getBuildSuccess(MavenProject project) {
        return this.buildSuccessesByProject.get(ReactorManager.getProjectKey(project));
    }

    public boolean executedMultipleProjects() {
        return this.buildFailuresByProject.size() + this.buildSuccessesByProject.size() > 1;
    }
}

