/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.internal.aether;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.apache.maven.RepositoryUtils;
import io.quarkus.launcher.shaded.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import io.quarkus.launcher.shaded.org.apache.maven.bridge.MavenRepositorySystem;
import io.quarkus.launcher.shaded.org.apache.maven.eventspy.internal.EventSpyDispatcher;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.internal.aether.LoggingRepositoryListener;
import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystem;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.WorkspaceReader;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

@Named
public class DefaultRepositorySystemSessionFactory {
    @Inject
    private Logger logger;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    private RepositorySystem repoSystem;
    @Inject
    @Nullable
    @Named(value="io.quarkus.launcher.shaded.simple")
    private LocalRepositoryManagerFactory simpleLocalRepoMgrFactory;
    @Inject
    @Nullable
    @Named(value="io.quarkus.launcher.shaded.ide")
    private WorkspaceReader workspaceRepository;
    @Inject
    private SettingsDecrypter settingsDecrypter;
    @Inject
    private EventSpyDispatcher eventSpyDispatcher;
    @Inject
    MavenRepositorySystem mavenRepositorySystem;

    public DefaultRepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setCache(request.getRepositoryCache());
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("io.quarkus.launcher.shaded.aether.connector.userAgent", this.getUserAgent());
        configProps.put("io.quarkus.launcher.shaded.aether.interactive", request.isInteractiveMode());
        configProps.putAll(request.getSystemProperties());
        configProps.putAll(request.getUserProperties());
        session.setOffline(request.isOffline());
        session.setChecksumPolicy(request.getGlobalChecksumPolicy());
        if (request.isNoSnapshotUpdates()) {
            session.setUpdatePolicy("io.quarkus.launcher.shaded.never");
        } else if (request.isUpdateSnapshots()) {
            session.setUpdatePolicy("io.quarkus.launcher.shaded.always");
        } else {
            session.setUpdatePolicy(null);
        }
        int errorPolicy = 0;
        errorPolicy |= request.isCacheNotFound() ? 1 : 0;
        session.setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(errorPolicy |= request.isCacheTransferError() ? 2 : 0, errorPolicy | 1));
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry(this.artifactHandlerManager));
        LocalRepository localRepo = new LocalRepository(request.getLocalRepository().getBasedir());
        if (request.isUseLegacyLocalRepository()) {
            try {
                session.setLocalRepositoryManager(this.simpleLocalRepoMgrFactory.newInstance(session, localRepo));
                this.logger.info("io.quarkus.launcher.shaded.Disabling enhanced local repository: using legacy is strongly discouraged to ensure build reproducibility.");
            }
            catch (NoLocalRepositoryManagerException e) {
                this.logger.error("io.quarkus.launcher.shaded.Failed to configure legacy local repository: falling back to default");
                session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(session, localRepo));
            }
        } else {
            session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager(session, localRepo));
        }
        if (request.getWorkspaceReader() != null) {
            session.setWorkspaceReader(request.getWorkspaceReader());
        } else {
            session.setWorkspaceReader(this.workspaceRepository);
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)request.getProxies());
        decrypt.setServers((List)request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt(decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                this.logger.debug(settingsProblem.getMessage(), settingsProblem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector defaultProxySelector = new DefaultProxySelector();
        for (Proxy proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            defaultProxySelector.add(new io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector(defaultProxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultAuthenticationSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"io.quarkus.launcher.shaded.wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("io.quarkus.launcher.shaded.aether.connector.wagon.config." + server.getId(), config);
            }
            configProps.put("io.quarkus.launcher.shaded.aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("io.quarkus.launcher.shaded.aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(defaultAuthenticationSelector);
        session.setTransferListener(request.getTransferListener());
        session.setRepositoryListener(this.eventSpyDispatcher.chainListener(new LoggingRepositoryListener(this.logger)));
        session.setUserProperties(request.getUserProperties());
        session.setSystemProperties(request.getSystemProperties());
        session.setConfigProperties(configProps);
        this.mavenRepositorySystem.injectMirror(request.getRemoteRepositories(), request.getMirrors());
        this.mavenRepositorySystem.injectProxy(session, request.getRemoteRepositories());
        this.mavenRepositorySystem.injectAuthentication(session, request.getRemoteRepositories());
        this.mavenRepositorySystem.injectMirror(request.getPluginArtifactRepositories(), request.getMirrors());
        this.mavenRepositorySystem.injectProxy(session, request.getPluginArtifactRepositories());
        this.mavenRepositorySystem.injectAuthentication(session, request.getPluginArtifactRepositories());
        return session;
    }

    private String getUserAgent() {
        return "io/quarkus/launcher/shaded/Apache-Maven/" + this.getMavenVersion() + "io.quarkus.launcher.shaded. (Java " + System.getProperty("io/quarkus/launcher/shaded/java.version") + "io.quarkus.launcher.shaded.; " + System.getProperty("io.quarkus.launcher.shaded.os.name") + "io.quarkus.launcher.shaded. " + System.getProperty("io.quarkus.launcher.shaded.os.version") + "io.quarkus.launcher.shaded.)";
    }

    private String getMavenVersion() {
        Properties props = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            this.logger.debug("io.quarkus.launcher.shaded.Failed to read Maven version", e);
        }
        return props.getProperty("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.unknown-version");
    }
}

