/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.internal.aether;

import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.eclipse.aether.AbstractRepositoryListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.MetadataNotFoundException;
import java.io.FileNotFoundException;

class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    LoggingRepositoryListener(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void artifactInstalling(RepositoryEvent event) {
        this.logger.info("io.quarkus.launcher.shaded.Installing " + event.getArtifact().getFile() + "io.quarkus.launcher.shaded. to " + event.getFile());
    }

    @Override
    public void metadataInstalling(RepositoryEvent event) {
        this.logger.debug("io.quarkus.launcher.shaded.Installing " + event.getMetadata() + "io.quarkus.launcher.shaded. to " + event.getFile());
    }

    @Override
    public void metadataResolved(RepositoryEvent event) {
        Exception e = event.getException();
        if (e != null) {
            if (e instanceof MetadataNotFoundException) {
                this.logger.debug(e.getMessage());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(e.getMessage(), e);
            } else {
                this.logger.warn(e.getMessage());
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event) {
        Exception exception = event.getException();
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.The metadata ");
        if (event.getMetadata().getFile() != null) {
            buffer.append(event.getMetadata().getFile());
        } else {
            buffer.append(event.getMetadata());
        }
        if (exception instanceof FileNotFoundException) {
            buffer.append("io.quarkus.launcher.shaded. is inaccessible");
        } else {
            buffer.append("io.quarkus.launcher.shaded. is invalid");
        }
        if (exception != null) {
            buffer.append("io.quarkus.launcher.shaded.: ");
            buffer.append(exception.getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer.toString(), exception);
        } else {
            this.logger.warn(buffer.toString());
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.The POM for ");
        buffer.append(event.getArtifact());
        buffer.append("io.quarkus.launcher.shaded. is invalid, transitive dependencies (if any) will not be available");
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer + "io.quarkus.launcher.shaded.: " + event.getException().getMessage());
        } else {
            this.logger.warn(buffer + "io.quarkus.launcher.shaded., enable debug logging for more details");
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.logger.warn("io.quarkus.launcher.shaded.The POM for " + event.getArtifact() + "io.quarkus.launcher.shaded. is missing, no dependency information available");
    }
}

