/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle;

import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.Lifecycle;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

@Component(role=DefaultLifecycles.class)
public class DefaultLifecycles {
    public static final String[] STANDARD_LIFECYCLES = new String[]{"io.quarkus.launcher.shaded.default", "io.quarkus.launcher.shaded.clean", "io.quarkus.launcher.shaded.site"};
    @Requirement(role=Lifecycle.class)
    private Map<String, Lifecycle> lifecycles;
    @Requirement
    private Logger logger;

    public DefaultLifecycles() {
    }

    public DefaultLifecycles(Map<String, Lifecycle> lifecycles, Logger logger) {
        this.lifecycles = new LinkedHashMap<String, Lifecycle>();
        this.logger = logger;
        this.lifecycles = lifecycles;
    }

    public Lifecycle get(String key) {
        return this.getPhaseToLifecycleMap().get(key);
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        for (Lifecycle lifecycle : this.getLifeCycles()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("io.quarkus.launcher.shaded.Lifecycle " + lifecycle);
            }
            for (String phase : lifecycle.getPhases()) {
                if (!phaseToLifecycleMap.containsKey(phase)) {
                    phaseToLifecycleMap.put(phase, lifecycle);
                    continue;
                }
                Lifecycle original = phaseToLifecycleMap.get(phase);
                this.logger.warn("io.quarkus.launcher.shaded.Duplicated lifecycle phase " + phase + "io.quarkus.launcher.shaded.. Defined in " + original.getId() + "io.quarkus.launcher.shaded. but also in " + lifecycle.getId());
            }
        }
        return phaseToLifecycleMap;
    }

    public List<Lifecycle> getLifeCycles() {
        LinkedHashMap<String, Lifecycle> lifecycles = new LinkedHashMap<String, Lifecycle>(this.lifecycles);
        LinkedHashSet<String> lifecycleNames = new LinkedHashSet<String>(Arrays.asList(STANDARD_LIFECYCLES));
        lifecycleNames.addAll(lifecycles.keySet());
        ArrayList<Lifecycle> result = new ArrayList<Lifecycle>();
        for (String name : lifecycleNames) {
            Lifecycle lifecycle = (Lifecycle)lifecycles.get(name);
            if (lifecycle.getId() == null) {
                throw new NullPointerException("io.quarkus.launcher.shaded.A lifecycle must have an id.");
            }
            result.add(lifecycle);
        }
        return result;
    }

    public String getLifecyclePhaseList() {
        LinkedHashSet<String> phases = new LinkedHashSet<String>();
        for (Lifecycle lifecycle : this.getLifeCycles()) {
            phases.addAll(lifecycle.getPhases());
        }
        return StringUtils.join(phases.iterator(), "io.quarkus.launcher.shaded., ");
    }
}

