/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectBuildList;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectSegment;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.TaskSegment;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Component(role=BuildListCalculator.class)
public class BuildListCalculator {
    public ProjectBuildList calculateProjectBuilds(MavenSession session, List<TaskSegment> taskSegments) {
        ArrayList<ProjectSegment> projectBuilds = new ArrayList<ProjectSegment>();
        MavenProject rootProject = session.getTopLevelProject();
        for (TaskSegment taskSegment : taskSegments) {
            List<MavenProject> projects = taskSegment.isAggregating() ? Collections.singletonList(rootProject) : session.getProjects();
            for (MavenProject project : projects) {
                BuilderCommon.attachToThread(project);
                MavenSession copiedSession = session.clone();
                copiedSession.setCurrentProject(project);
                projectBuilds.add(new ProjectSegment(project, taskSegment, copiedSession));
            }
        }
        return new ProjectBuildList(projectBuilds);
    }
}

