/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.DefaultLifecycles;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.Lifecycle;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleMappingDelegate;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.MavenExecutionPlan;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.MojoExecutionConfigurator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.DefaultMojoExecutionConfigurator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.GoalTask;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleTask;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.BuildPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.Parameter;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.PluginDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.lifecycle.Execution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.lifecycle.Phase;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolver;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component(role=LifecycleExecutionPlanCalculator.class)
public class DefaultLifecycleExecutionPlanCalculator
implements LifecycleExecutionPlanCalculator {
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;
    @Requirement(hint="io.quarkus.launcher.shaded.default")
    private LifecycleMappingDelegate standardDelegate;
    @Requirement
    private Map<String, LifecycleMappingDelegate> delegates;
    @Requirement
    private Map<String, MojoExecutionConfigurator> mojoExecutionConfigurators;

    public DefaultLifecycleExecutionPlanCalculator() {
    }

    public DefaultLifecycleExecutionPlanCalculator(BuildPluginManager pluginManager, DefaultLifecycles defaultLifeCycles, MojoDescriptorCreator mojoDescriptorCreator, LifecyclePluginResolver lifecyclePluginResolver) {
        this.pluginManager = pluginManager;
        this.defaultLifeCycles = defaultLifeCycles;
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
        this.mojoExecutionConfigurators = Collections.singletonMap("io.quarkus.launcher.shaded.default", new DefaultMojoExecutionConfigurator());
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, MavenProject project, List<Object> tasks, boolean setup) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.lifecyclePluginResolver.resolveMissingPluginVersions(project, session);
        List<MojoExecution> executions = this.calculateMojoExecutions(session, project, tasks);
        if (setup) {
            this.setupMojoExecutions(session, project, executions);
        }
        List<ExecutionPlanItem> planItem = ExecutionPlanItem.createExecutionPlanItems(project, executions);
        return new MavenExecutionPlan(planItem, this.defaultLifeCycles);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, MavenProject project, List<Object> tasks) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        return this.calculateExecutionPlan(session, project, tasks, true);
    }

    private void setupMojoExecutions(MavenSession session, MavenProject project, List<MojoExecution> mojoExecutions) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        for (MojoExecution mojoExecution : mojoExecutions) {
            this.setupMojoExecution(session, project, mojoExecution);
        }
    }

    @Override
    public void setupMojoExecution(MavenSession session, MavenProject project, MojoExecution mojoExecution) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (mojoDescriptor == null) {
            mojoDescriptor = this.pluginManager.getMojoDescriptor(mojoExecution.getPlugin(), mojoExecution.getGoal(), project.getRemotePluginRepositories(), session.getRepositorySession());
            mojoExecution.setMojoDescriptor(mojoDescriptor);
        }
        this.mojoExecutionConfigurator(mojoExecution).configure(project, mojoExecution, MojoExecution.Source.CLI.equals((Object)mojoExecution.getSource()));
        this.finalizeMojoConfiguration(mojoExecution);
        this.calculateForkedExecutions(mojoExecution, session, project, new HashSet<MojoDescriptor>());
    }

    public List<MojoExecution> calculateMojoExecutions(MavenSession session, MavenProject project, List<Object> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException {
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (Object task : tasks) {
            if (task instanceof GoalTask) {
                String pluginGoal = ((GoalTask)task).pluginGoal;
                String executionId = "io.quarkus.launcher.shaded.default-cli";
                int executionIdx = pluginGoal.indexOf(64);
                if (executionIdx > 0) {
                    executionId = pluginGoal.substring(executionIdx + 1);
                }
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(pluginGoal, session, project);
                MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, executionId, MojoExecution.Source.CLI);
                mojoExecutions.add(mojoExecution);
                continue;
            }
            if (task instanceof LifecycleTask) {
                String lifecyclePhase = ((LifecycleTask)task).getLifecyclePhase();
                Map<String, List<MojoExecution>> phaseToMojoMapping = this.calculateLifecycleMappings(session, project, lifecyclePhase);
                for (List<MojoExecution> mojoExecutionsFromLifecycle : phaseToMojoMapping.values()) {
                    mojoExecutions.addAll(mojoExecutionsFromLifecycle);
                }
                continue;
            }
            throw new IllegalStateException("io.quarkus.launcher.shaded.unexpected task " + task);
        }
        return mojoExecutions;
    }

    private Map<String, List<MojoExecution>> calculateLifecycleMappings(MavenSession session, MavenProject project, String lifecyclePhase) throws LifecyclePhaseNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        LifecycleMappingDelegate delegate;
        Lifecycle lifecycle = this.defaultLifeCycles.get(lifecyclePhase);
        if (lifecycle == null) {
            throw new LifecyclePhaseNotFoundException("io.quarkus.launcher.shaded.Unknown lifecycle phase \"" + lifecyclePhase + "io.quarkus.launcher.shaded.\". You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + "io.quarkus.launcher.shaded..", lifecyclePhase);
        }
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) >= 0) {
            delegate = this.standardDelegate;
        } else {
            delegate = this.delegates.get(lifecycle.getId());
            if (delegate == null) {
                delegate = this.standardDelegate;
            }
        }
        return delegate.calculateLifecycleMappings(session, project, lifecycle, lifecyclePhase);
    }

    private void finalizeMojoConfiguration(MojoExecution mojoExecution) {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Xpp3Dom executionConfiguration = mojoExecution.getConfiguration();
        if (executionConfiguration == null) {
            executionConfiguration = new Xpp3Dom("io.quarkus.launcher.shaded.configuration");
        }
        Xpp3Dom defaultConfiguration = this.getMojoConfiguration(mojoDescriptor);
        Xpp3Dom finalConfiguration = new Xpp3Dom("io.quarkus.launcher.shaded.configuration");
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom(parameterConfiguration, parameterDefaults = defaultConfiguration.getChild(parameter.getName()), Boolean.TRUE)) == null) continue;
                if (StringUtils.isEmpty((parameterConfiguration = new Xpp3Dom(parameterConfiguration, parameter.getName())).getAttribute("io.quarkus.launcher.shaded.implementation")) && StringUtils.isNotEmpty(parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("io.quarkus.launcher.shaded.implementation", parameter.getImplementation());
                }
                finalConfiguration.addChild(parameterConfiguration);
            }
        }
        mojoExecution.setConfiguration(finalConfiguration);
    }

    private Xpp3Dom getMojoConfiguration(MojoDescriptor mojoDescriptor) {
        return MojoDescriptorCreator.convert(mojoDescriptor);
    }

    @Override
    public void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.calculateForkedExecutions(mojoExecution, session, session.getCurrentProject(), new HashSet<MojoDescriptor>());
    }

    private void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session, MavenProject project, Collection<MojoDescriptor> alreadyForkedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (!mojoDescriptor.isForking()) {
            return;
        }
        if (!alreadyForkedExecutions.add(mojoDescriptor)) {
            return;
        }
        List<MavenProject> forkedProjects = LifecycleDependencyResolver.getProjects(project, session, mojoDescriptor.isAggregator());
        for (MavenProject forkedProject : forkedProjects) {
            if (forkedProject != project) {
                this.lifecyclePluginResolver.resolveMissingPluginVersions(forkedProject, session);
            }
            List<MojoExecution> forkedExecutions = StringUtils.isNotEmpty(mojoDescriptor.getExecutePhase()) ? this.calculateForkedLifecycle(mojoExecution, session, forkedProject, alreadyForkedExecutions) : this.calculateForkedGoal(mojoExecution, session, forkedProject, alreadyForkedExecutions);
            mojoExecution.setForkedExecutions(BuilderCommon.getKey(forkedProject), forkedExecutions);
        }
        alreadyForkedExecutions.remove(mojoDescriptor);
    }

    private List<MojoExecution> calculateForkedLifecycle(MojoExecution mojoExecution, MavenSession session, MavenProject project, Collection<MojoDescriptor> alreadyForkedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        String forkedPhase = mojoDescriptor.getExecutePhase();
        Map<String, List<MojoExecution>> lifecycleMappings = this.calculateLifecycleMappings(session, project, forkedPhase);
        for (List<MojoExecution> forkedExecutions : lifecycleMappings.values()) {
            for (MojoExecution forkedExecution : forkedExecutions) {
                if (forkedExecution.getMojoDescriptor() == null) {
                    MojoDescriptor forkedMojoDescriptor = this.pluginManager.getMojoDescriptor(forkedExecution.getPlugin(), forkedExecution.getGoal(), project.getRemotePluginRepositories(), session.getRepositorySession());
                    forkedExecution.setMojoDescriptor(forkedMojoDescriptor);
                }
                this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, false);
            }
        }
        this.injectLifecycleOverlay(lifecycleMappings, mojoExecution, session, project);
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (List<MojoExecution> forkedExecutions : lifecycleMappings.values()) {
            for (MojoExecution forkedExecution : forkedExecutions) {
                if (alreadyForkedExecutions.contains(forkedExecution.getMojoDescriptor())) continue;
                this.finalizeMojoConfiguration(forkedExecution);
                this.calculateForkedExecutions(forkedExecution, session, project, alreadyForkedExecutions);
                mojoExecutions.add(forkedExecution);
            }
        }
        return mojoExecutions;
    }

    private void injectLifecycleOverlay(Map<String, List<MojoExecution>> lifecycleMappings, MojoExecution mojoExecution, MavenSession session, MavenProject project) throws PluginDescriptorParsingException, LifecycleNotFoundException, MojoNotFoundException, PluginNotFoundException, PluginResolutionException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        io.quarkus.launcher.shaded.org.apache.maven.plugin.lifecycle.Lifecycle lifecycleOverlay;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        String forkedLifecycle = mojoDescriptor.getExecuteLifecycle();
        if (StringUtils.isEmpty(forkedLifecycle)) {
            return;
        }
        try {
            lifecycleOverlay = pluginDescriptor.getLifecycleMapping(forkedLifecycle);
        }
        catch (XmlPullParserException | IOException e) {
            throw new PluginDescriptorParsingException(pluginDescriptor.getPlugin(), pluginDescriptor.getSource(), e);
        }
        if (lifecycleOverlay == null) {
            throw new LifecycleNotFoundException(forkedLifecycle);
        }
        for (Phase phase : lifecycleOverlay.getPhases()) {
            List<MojoExecution> forkedExecutions = lifecycleMappings.get(phase.getId());
            if (forkedExecutions == null) continue;
            for (Execution execution : phase.getExecutions()) {
                for (String goal : execution.getGoals()) {
                    MojoDescriptor forkedMojoDescriptor;
                    if (goal.indexOf(58) < 0) {
                        forkedMojoDescriptor = pluginDescriptor.getMojo(goal);
                        if (forkedMojoDescriptor == null) {
                            throw new MojoNotFoundException(goal, pluginDescriptor);
                        }
                    } else {
                        forkedMojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(goal, session, project);
                    }
                    MojoExecution forkedExecution = new MojoExecution(forkedMojoDescriptor, mojoExecution.getExecutionId());
                    Xpp3Dom forkedConfiguration = (Xpp3Dom)execution.getConfiguration();
                    forkedExecution.setConfiguration(forkedConfiguration);
                    this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, true);
                    forkedExecutions.add(forkedExecution);
                }
            }
            Xpp3Dom phaseConfiguration = (Xpp3Dom)phase.getConfiguration();
            if (phaseConfiguration == null) continue;
            for (MojoExecution forkedExecution : forkedExecutions) {
                Xpp3Dom forkedConfiguration = forkedExecution.getConfiguration();
                forkedConfiguration = Xpp3Dom.mergeXpp3Dom(phaseConfiguration, forkedConfiguration);
                forkedExecution.setConfiguration(forkedConfiguration);
            }
        }
    }

    private List<MojoExecution> calculateForkedGoal(MojoExecution mojoExecution, MavenSession session, MavenProject project, Collection<MojoDescriptor> alreadyForkedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        String forkedGoal;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        MojoDescriptor forkedMojoDescriptor = pluginDescriptor.getMojo(forkedGoal = mojoDescriptor.getExecuteGoal());
        if (forkedMojoDescriptor == null) {
            throw new MojoNotFoundException(forkedGoal, pluginDescriptor);
        }
        if (alreadyForkedExecutions.contains(forkedMojoDescriptor)) {
            return Collections.emptyList();
        }
        MojoExecution forkedExecution = new MojoExecution(forkedMojoDescriptor, forkedGoal);
        this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, true);
        this.finalizeMojoConfiguration(forkedExecution);
        this.calculateForkedExecutions(forkedExecution, session, project, alreadyForkedExecutions);
        return Collections.singletonList(forkedExecution);
    }

    private MojoExecutionConfigurator mojoExecutionConfigurator(MojoExecution mojoExecution) {
        MojoExecutionConfigurator mojoExecutionConfigurator;
        String configuratorId = mojoExecution.getMojoDescriptor().getComponentConfigurator();
        if (configuratorId == null) {
            configuratorId = "io.quarkus.launcher.shaded.default";
        }
        if ((mojoExecutionConfigurator = this.mojoExecutionConfigurators.get(configuratorId)) == null) {
            mojoExecutionConfigurator = this.mojoExecutionConfigurators.get("io.quarkus.launcher.shaded.default");
        }
        return mojoExecutionConfigurator;
    }
}

