/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.Lifecycle;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleMappingDelegate;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.model.PluginExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.BuildPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Component(role=LifecycleMappingDelegate.class, hint="io.quarkus.launcher.shaded.default")
public class DefaultLifecycleMappingDelegate
implements LifecycleMappingDelegate {
    public static final String HINT = "io.quarkus.launcher.shaded.default";
    @Requirement
    private BuildPluginManager pluginManager;

    @Override
    public Map<String, List<MojoExecution>> calculateLifecycleMappings(MavenSession session, MavenProject project, Lifecycle lifecycle, String lifecyclePhase) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        LinkedHashMap mappings = new LinkedHashMap();
        for (String phase : lifecycle.getPhases()) {
            TreeMap phaseBindings = new TreeMap();
            mappings.put(phase, phaseBindings);
            if (!phase.equals(lifecyclePhase)) continue;
            break;
        }
        for (Plugin plugin : project.getBuild().getPlugins()) {
            for (PluginExecution execution : plugin.getExecutions()) {
                if (execution.getPhase() != null) {
                    Map phaseBindings = (Map)mappings.get(execution.getPhase());
                    if (phaseBindings == null) continue;
                    for (String goal : execution.getGoals()) {
                        MojoExecution mojoExecution = new MojoExecution(plugin, goal, execution.getId());
                        mojoExecution.setLifecyclePhase(execution.getPhase());
                        this.addMojoExecution(phaseBindings, mojoExecution, execution.getPriority());
                    }
                    continue;
                }
                for (String goal : execution.getGoals()) {
                    MojoDescriptor mojoDescriptor = this.pluginManager.getMojoDescriptor(plugin, goal, project.getRemotePluginRepositories(), session.getRepositorySession());
                    Map phaseBindings = (Map)mappings.get(mojoDescriptor.getPhase());
                    if (phaseBindings == null) continue;
                    MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, execution.getId());
                    mojoExecution.setLifecyclePhase(mojoDescriptor.getPhase());
                    this.addMojoExecution(phaseBindings, mojoExecution, execution.getPriority());
                }
            }
        }
        LinkedHashMap<String, List<MojoExecution>> lifecycleMappings = new LinkedHashMap<String, List<MojoExecution>>();
        for (Map.Entry entry : mappings.entrySet()) {
            ArrayList mojoExecutions = new ArrayList();
            for (List executions : ((Map)entry.getValue()).values()) {
                mojoExecutions.addAll(executions);
            }
            lifecycleMappings.put((String)entry.getKey(), mojoExecutions);
        }
        return lifecycleMappings;
    }

    private void addMojoExecution(Map<Integer, List<MojoExecution>> phaseBindings, MojoExecution mojoExecution, int priority) {
        List<MojoExecution> mojoExecutions = phaseBindings.get(priority);
        if (mojoExecutions == null) {
            mojoExecutions = new ArrayList<MojoExecution>();
            phaseBindings.put(priority, mojoExecutions);
        }
        mojoExecutions.add(mojoExecution);
    }
}

