/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.GoalTask;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleTask;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.TaskSegment;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component(role=LifecycleTaskSegmentCalculator.class)
public class DefaultLifecycleTaskSegmentCalculator
implements LifecycleTaskSegmentCalculator {
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException {
        MavenProject rootProject = session.getTopLevelProject();
        List<String> tasks = session.getGoals();
        if ((tasks == null || tasks.isEmpty()) && !StringUtils.isEmpty(rootProject.getDefaultGoal())) {
            tasks = Arrays.asList(StringUtils.split(rootProject.getDefaultGoal()));
        }
        return this.calculateTaskSegments(session, tasks);
    }

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session, List<String> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        ArrayList<TaskSegment> taskSegments = new ArrayList<TaskSegment>(tasks.size());
        TaskSegment currentSegment = null;
        for (String task : tasks) {
            if (this.isGoalSpecification(task)) {
                boolean aggregating;
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session.getTopLevelProject(), session);
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(task, session, session.getTopLevelProject());
                boolean bl = aggregating = mojoDescriptor.isAggregator() || !mojoDescriptor.isProjectRequired();
                if (currentSegment == null || currentSegment.isAggregating() != aggregating) {
                    currentSegment = new TaskSegment(aggregating);
                    taskSegments.add(currentSegment);
                }
                currentSegment.getTasks().add(new GoalTask(task));
                continue;
            }
            if (currentSegment == null || currentSegment.isAggregating()) {
                currentSegment = new TaskSegment(false);
                taskSegments.add(currentSegment);
            }
            currentSegment.getTasks().add(new LifecycleTask(task));
        }
        return taskSegments;
    }

    @Override
    public boolean requiresProject(MavenSession session) {
        List<String> goals = session.getGoals();
        if (goals != null) {
            for (String goal : goals) {
                if (this.isGoalSpecification(goal)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGoalSpecification(String task) {
        return task.indexOf(58) >= 0;
    }
}

