/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.MavenExecutionPlan;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectBuildList;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectSegment;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoExecution;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

@Component(role=LifecycleDebugLogger.class)
public class LifecycleDebugLogger {
    @Requirement
    private Logger logger;

    public LifecycleDebugLogger() {
    }

    public LifecycleDebugLogger(Logger logger) {
        this.logger = logger;
    }

    public void debug(String s) {
        this.logger.debug(s);
    }

    public void info(String s) {
        this.logger.info(s);
    }

    public void debugReactorPlan(ProjectBuildList projectBuilds) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("io.quarkus.launcher.shaded.=== REACTOR BUILD PLAN ================================================");
        Iterator<ProjectSegment> it = projectBuilds.iterator();
        while (it.hasNext()) {
            ProjectSegment projectBuild = it.next();
            this.logger.debug("io.quarkus.launcher.shaded.Project: " + projectBuild.getProject().getId());
            this.logger.debug("io.quarkus.launcher.shaded.Tasks:   " + projectBuild.getTaskSegment().getTasks());
            this.logger.debug("io.quarkus.launcher.shaded.Style:   " + (projectBuild.getTaskSegment().isAggregating() ? "io.quarkus.launcher.shaded.Aggregating" : "io.quarkus.launcher.shaded.Regular"));
            if (!it.hasNext()) continue;
            this.logger.debug("io.quarkus.launcher.shaded.-----------------------------------------------------------------------");
        }
        this.logger.debug("io.quarkus.launcher.shaded.=======================================================================");
    }

    public void debugProjectPlan(MavenProject currentProject, MavenExecutionPlan executionPlan) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("io.quarkus.launcher.shaded.=== PROJECT BUILD PLAN ================================================");
        this.logger.debug("io.quarkus.launcher.shaded.Project:       " + BuilderCommon.getKey(currentProject));
        this.debugDependencyRequirements(executionPlan.getMojoExecutions());
        this.logger.debug("io.quarkus.launcher.shaded.Repositories (dependencies): " + currentProject.getRemoteProjectRepositories());
        this.logger.debug("io.quarkus.launcher.shaded.Repositories (plugins)     : " + currentProject.getRemotePluginRepositories());
        for (ExecutionPlanItem mojoExecution : executionPlan) {
            this.debugMojoExecution(mojoExecution.getMojoExecution());
        }
        this.logger.debug("io.quarkus.launcher.shaded.=======================================================================");
    }

    private void debugMojoExecution(MojoExecution mojoExecution) {
        String mojoExecId = mojoExecution.getGroupId() + ':' + mojoExecution.getArtifactId() + ':' + mojoExecution.getVersion() + ':' + mojoExecution.getGoal() + "io.quarkus.launcher.shaded. (" + mojoExecution.getExecutionId() + ')';
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                this.logger.debug("io.quarkus.launcher.shaded.--- init fork of " + fork.getKey() + "io.quarkus.launcher.shaded. for " + mojoExecId + "io.quarkus.launcher.shaded. ---");
                this.debugDependencyRequirements(fork.getValue());
                for (MojoExecution forkedExecution : fork.getValue()) {
                    this.debugMojoExecution(forkedExecution);
                }
                this.logger.debug("io.quarkus.launcher.shaded.--- exit fork of " + fork.getKey() + "io.quarkus.launcher.shaded. for " + mojoExecId + "io.quarkus.launcher.shaded. ---");
            }
        }
        this.logger.debug("io.quarkus.launcher.shaded.-----------------------------------------------------------------------");
        this.logger.debug("io.quarkus.launcher.shaded.Goal:          " + mojoExecId);
        this.logger.debug("io.quarkus.launcher.shaded.Style:         " + (mojoExecution.getMojoDescriptor().isAggregator() ? "io.quarkus.launcher.shaded.Aggregating" : "io.quarkus.launcher.shaded.Regular"));
        this.logger.debug("io.quarkus.launcher.shaded.Configuration: " + mojoExecution.getConfiguration());
    }

    private void debugDependencyRequirements(List<MojoExecution> mojoExecutions) {
        TreeSet<String> scopesToCollect = new TreeSet<String>();
        TreeSet<String> scopesToResolve = new TreeSet<String>();
        for (MojoExecution mojoExecution : mojoExecutions) {
            String scopeToResolve;
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
            if (StringUtils.isNotEmpty(scopeToCollect)) {
                scopesToCollect.add(scopeToCollect);
            }
            if (!StringUtils.isNotEmpty(scopeToResolve = mojoDescriptor.getDependencyResolutionRequired())) continue;
            scopesToResolve.add(scopeToResolve);
        }
        this.logger.debug("io.quarkus.launcher.shaded.Dependencies (collect): " + scopesToCollect);
        this.logger.debug("io.quarkus.launcher.shaded.Dependencies (resolve): " + scopesToResolve);
    }
}

