/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.ExecutionEvent;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenExecutionResult;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.DefaultLifecycles;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.MissingProjectException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.NoGoalSpecifiedException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.BuildListCalculator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectBuildList;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ProjectIndex;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ReactorContext;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.TaskSegment;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.Builder;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder.BuilderNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.session.scope.internal.SessionScope;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import java.util.List;
import java.util.Map;

@Component(role=LifecycleStarter.class)
public class LifecycleStarter {
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private Logger logger;
    @Requirement
    private BuildListCalculator buildListCalculator;
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    @Requirement
    private Map<String, Builder> builders;
    @Requirement
    private SessionScope sessionScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenSession session) {
        this.eventCatapult.fire(ExecutionEvent.Type.SessionStarted, session, null);
        ReactorContext reactorContext = null;
        ProjectBuildList projectBuilds = null;
        MavenExecutionResult result = session.getResult();
        try {
            if (this.buildExecutionRequiresProject(session) && this.projectIsNotPresent(session)) {
                throw new MissingProjectException("io.quarkus.launcher.shaded.The goal you specified requires a project to execute but there is no POM in this directory (" + session.getExecutionRootDirectory() + "io.quarkus.launcher.shaded.). Please verify you invoked Maven from the correct directory.");
            }
            List<TaskSegment> taskSegments = this.lifecycleTaskSegmentCalculator.calculateTaskSegments(session);
            projectBuilds = this.buildListCalculator.calculateProjectBuilds(session, taskSegments);
            if (projectBuilds.isEmpty()) {
                throw new NoGoalSpecifiedException("io.quarkus.launcher.shaded.No goals have been specified for this build. You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + "io.quarkus.launcher.shaded..");
            }
            ProjectIndex projectIndex = new ProjectIndex(session.getProjects());
            if (this.logger.isDebugEnabled()) {
                this.lifecycleDebugLogger.debugReactorPlan(projectBuilds);
            }
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            ReactorBuildStatus reactorBuildStatus = new ReactorBuildStatus(session.getProjectDependencyGraph());
            reactorContext = new ReactorContext(result, projectIndex, oldContextClassLoader, reactorBuildStatus, this.sessionScope.memento());
            String builderId = session.getRequest().getBuilderId();
            Builder builder = this.builders.get(builderId);
            if (builder == null) {
                throw new BuilderNotFoundException(String.format("io.quarkus.launcher.shaded.The builder requested using id = %s cannot be found", builderId));
            }
            int degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
            if (degreeOfConcurrency >= 2) {
                this.logger.info("io.quarkus.launcher.shaded.");
                this.logger.info(String.format("io.quarkus.launcher.shaded.Using the %s implementation with a thread count of %d", builder.getClass().getSimpleName(), degreeOfConcurrency));
            }
            builder.build(session, reactorContext, projectBuilds, taskSegments, reactorBuildStatus);
        }
        catch (Exception e) {
            result.addException(e);
        }
        finally {
            this.eventCatapult.fire(ExecutionEvent.Type.SessionEnded, session, null);
        }
    }

    private boolean buildExecutionRequiresProject(MavenSession session) {
        return this.lifecycleTaskSegmentCalculator.requiresProject(session);
    }

    private boolean projectIsNotPresent(MavenSession session) {
        return !session.getRequest().isProjectPresent();
    }
}

