/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import io.quarkus.launcher.shaded.org.apache.maven.model.Dependency;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.BuildPluginManager;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixResolver;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.PluginPrefixResult;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolver;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

@Component(role=MojoDescriptorCreator.class)
public class MojoDescriptorCreator {
    @Requirement
    private Logger logger;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private PluginPrefixResolver pluginPrefixResolver;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;

    public MojoDescriptorCreator() {
    }

    public MojoDescriptorCreator(PluginVersionResolver pluginVersionResolver, BuildPluginManager pluginManager, PluginPrefixResolver pluginPrefixResolver, LifecyclePluginResolver lifecyclePluginResolver) {
        this.pluginVersionResolver = pluginVersionResolver;
        this.pluginManager = pluginManager;
        this.pluginPrefixResolver = pluginPrefixResolver;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    public static Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        Xpp3Dom dom = new Xpp3Dom("io.quarkus.launcher.shaded.configuration");
        PlexusConfiguration c = mojoDescriptor.getMojoConfiguration();
        PlexusConfiguration[] ces = c.getChildren();
        if (ces != null) {
            for (PlexusConfiguration ce : ces) {
                String value = ce.getValue(null);
                String defaultValue = ce.getAttribute("io.quarkus.launcher.shaded.default-value", null);
                if (value == null && defaultValue == null) continue;
                Xpp3Dom e = new Xpp3Dom(ce.getName());
                e.setValue(value);
                if (defaultValue != null) {
                    e.setAttribute("io.quarkus.launcher.shaded.default-value", defaultValue);
                }
                dom.addChild(e);
            }
        }
        return dom;
    }

    public MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        int executionIdx;
        String goal = null;
        Plugin plugin = null;
        StringTokenizer tok = new StringTokenizer(task, "io.quarkus.launcher.shaded.:");
        int numTokens = tok.countTokens();
        if (numTokens >= 4) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            plugin.setVersion(tok.nextToken());
            goal = tok.nextToken();
            while (tok.hasMoreTokens()) {
                goal = goal + "io.quarkus.launcher.shaded.:" + tok.nextToken();
            }
        } else if (numTokens == 3) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            goal = tok.nextToken();
        } else if (numTokens <= 2) {
            String prefix = tok.nextToken();
            goal = numTokens == 2 ? tok.nextToken() : "io.quarkus.launcher.shaded.";
            plugin = this.findPluginForPrefix(prefix, session);
        }
        if ((executionIdx = goal.indexOf(64)) > 0) {
            goal = goal.substring(0, executionIdx);
        }
        this.injectPluginDeclarationFromProject(plugin, project);
        if (plugin.getVersion() == null) {
            this.resolvePluginVersion(plugin, session, project);
        }
        return this.pluginManager.getMojoDescriptor(plugin, goal, project.getRemotePluginRepositories(), session.getRepositorySession());
    }

    public Plugin findPluginForPrefix(String prefix, MavenSession session) throws NoPluginFoundForPrefixException {
        if (session.getCurrentProject() != null) {
            try {
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session.getCurrentProject(), session);
            }
            catch (PluginVersionResolutionException e) {
                this.logger.debug(e.getMessage(), e);
            }
        }
        DefaultPluginPrefixRequest prefixRequest = new DefaultPluginPrefixRequest(prefix, session);
        PluginPrefixResult prefixResult = this.pluginPrefixResolver.resolve(prefixRequest);
        Plugin plugin = new Plugin();
        plugin.setGroupId(prefixResult.getGroupId());
        plugin.setArtifactId(prefixResult.getArtifactId());
        return plugin;
    }

    private void resolvePluginVersion(Plugin plugin, MavenSession session, MavenProject project) throws PluginVersionResolutionException {
        DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
        plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
    }

    private void injectPluginDeclarationFromProject(Plugin plugin, MavenProject project) {
        Plugin pluginInPom = this.findPlugin(plugin, project.getBuildPlugins());
        if (pluginInPom == null && project.getPluginManagement() != null) {
            pluginInPom = this.findPlugin(plugin, project.getPluginManagement().getPlugins());
        }
        if (pluginInPom != null) {
            if (plugin.getVersion() == null) {
                plugin.setVersion(pluginInPom.getVersion());
            }
            plugin.setDependencies(new ArrayList<Dependency>(pluginInPom.getDependencies()));
        }
    }

    private Plugin findPlugin(Plugin plugin, Collection<Plugin> plugins) {
        return this.findPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugins);
    }
}

