/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal;

import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.execution.ProjectDependencyGraph;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.TaskSegment;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import java.util.List;

public final class ProjectSegment {
    private final MavenProject project;
    private final TaskSegment taskSegment;
    private final MavenSession session;
    private final List<MavenProject> nonTransitiveUpstreamProjects;
    private final List<MavenProject> transitiveUpstreamProjects;

    public ProjectSegment(MavenProject project, TaskSegment taskSegment, MavenSession copiedSession) {
        this.project = project;
        this.taskSegment = taskSegment;
        this.session = copiedSession;
        ProjectDependencyGraph dependencyGraph = this.getSession().getProjectDependencyGraph();
        this.nonTransitiveUpstreamProjects = dependencyGraph.getUpstreamProjects(this.getProject(), false);
        this.transitiveUpstreamProjects = dependencyGraph.getUpstreamProjects(this.getProject(), true);
    }

    public MavenSession getSession() {
        return this.session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public TaskSegment getTaskSegment() {
        return this.taskSegment;
    }

    public List<MavenProject> getImmediateUpstreamProjects() {
        return this.nonTransitiveUpstreamProjects;
    }

    public List<MavenProject> getTransitiveUpstreamProjects() {
        return this.transitiveUpstreamProjects;
    }

    public String toString() {
        return this.getProject().getId() + "io.quarkus.launcher.shaded. -> " + this.getTaskSegment();
    }
}

