/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.builder;

import io.quarkus.launcher.shaded.org.apache.maven.artifact.Artifact;
import io.quarkus.launcher.shaded.org.apache.maven.execution.BuildFailure;
import io.quarkus.launcher.shaded.org.apache.maven.execution.ExecutionEvent;
import io.quarkus.launcher.shaded.org.apache.maven.execution.MavenSession;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleExecutionException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecycleNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.MavenExecutionPlan;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.ReactorContext;
import io.quarkus.launcher.shaded.org.apache.maven.lifecycle.internal.TaskSegment;
import io.quarkus.launcher.shaded.org.apache.maven.model.Plugin;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.InvalidPluginDescriptorException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.MojoNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginDescriptorParsingException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginNotFoundException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.PluginResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.descriptor.MojoDescriptor;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import io.quarkus.launcher.shaded.org.apache.maven.plugin.version.PluginVersionResolutionException;
import io.quarkus.launcher.shaded.org.apache.maven.project.MavenProject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Component;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import java.util.Set;

@Component(role=BuilderCommon.class)
public class BuilderCommon {
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private Logger logger;

    public BuilderCommon() {
    }

    public BuilderCommon(LifecycleDebugLogger lifecycleDebugLogger, LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator, Logger logger) {
        this.lifecycleDebugLogger = lifecycleDebugLogger;
        this.lifeCycleExecutionPlanCalculator = lifeCycleExecutionPlanCalculator;
        this.logger = logger;
    }

    public MavenExecutionPlan resolveBuildPlan(MavenSession session, MavenProject project, TaskSegment taskSegment, Set<Artifact> projectArtifacts) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException, LifecycleExecutionException {
        Set<Plugin> unsafePlugins;
        MavenExecutionPlan executionPlan = this.lifeCycleExecutionPlanCalculator.calculateExecutionPlan(session, project, taskSegment.getTasks());
        this.lifecycleDebugLogger.debugProjectPlan(project, executionPlan);
        if (session.getRequest().getDegreeOfConcurrency() > 1 && !(unsafePlugins = executionPlan.getNonThreadSafePlugins()).isEmpty()) {
            this.logger.warn("io.quarkus.launcher.shaded.*****************************************************************");
            this.logger.warn("io.quarkus.launcher.shaded.* Your build is requesting parallel execution, but project      *");
            this.logger.warn("io.quarkus.launcher.shaded.* contains the following plugin(s) that have goals not marked   *");
            this.logger.warn("io.quarkus.launcher.shaded.* as @threadSafe to support parallel building.                  *");
            this.logger.warn("io/quarkus/launcher/shaded/* While this /may/ work fine, please look for plugin updates    *");
            this.logger.warn("io/quarkus/launcher/shaded/* and/or request plugins be made thread-safe.                   *");
            this.logger.warn("io.quarkus.launcher.shaded.* If reporting an issue, report it against the plugin in        *");
            this.logger.warn("io.quarkus.launcher.shaded.* question, not against maven-core                              *");
            this.logger.warn("io.quarkus.launcher.shaded.*****************************************************************");
            if (this.logger.isDebugEnabled()) {
                Set<MojoDescriptor> unsafeGoals = executionPlan.getNonThreadSafeMojos();
                this.logger.warn("io.quarkus.launcher.shaded.The following goals are not marked @threadSafe in " + project.getName() + "io.quarkus.launcher.shaded.:");
                for (MojoDescriptor unsafeGoal : unsafeGoals) {
                    this.logger.warn(unsafeGoal.getId());
                }
            } else {
                this.logger.warn("io.quarkus.launcher.shaded.The following plugins are not marked @threadSafe in " + project.getName() + "io.quarkus.launcher.shaded.:");
                for (Plugin unsafePlugin : unsafePlugins) {
                    this.logger.warn(unsafePlugin.getId());
                }
                this.logger.warn("io.quarkus.launcher.shaded.Enable debug to see more precisely which goals are not marked @threadSafe.");
            }
            this.logger.warn("io.quarkus.launcher.shaded.*****************************************************************");
        }
        return executionPlan;
    }

    public void handleBuildError(ReactorContext buildContext, MavenSession rootSession, MavenSession currentSession, MavenProject mavenProject, Throwable t, long buildStartTime) {
        long buildEndTime = System.currentTimeMillis();
        buildContext.getResult().addException(t);
        buildContext.getResult().addBuildSummary(new BuildFailure(mavenProject, buildEndTime - buildStartTime, t));
        if (t instanceof Exception && !(t instanceof RuntimeException)) {
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectFailed, currentSession, null, (Exception)t);
        }
        if (t instanceof RuntimeException || !(t instanceof Exception)) {
            buildContext.getReactorBuildStatus().halt();
        } else if (!"io.quarkus.launcher.shaded.FAIL_NEVER".equals(rootSession.getReactorFailureBehavior())) {
            if ("io.quarkus.launcher.shaded.FAIL_AT_END".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().blackList(mavenProject);
            } else if ("io.quarkus.launcher.shaded.FAIL_FAST".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().halt();
            } else {
                this.logger.error("io.quarkus.launcher.shaded.invalid reactor failure behavior " + rootSession.getReactorFailureBehavior());
                buildContext.getReactorBuildStatus().halt();
            }
        }
    }

    public static void attachToThread(MavenProject currentProject) {
        ClassRealm projectRealm = currentProject.getClassRealm();
        if (projectRealm != null) {
            Thread.currentThread().setContextClassLoader(projectRealm);
        }
    }

    public static String getKey(MavenProject project) {
        return project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion();
    }
}

